/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.dom;

import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;

/**
 * @see SpringCustomNamespaces
 * @since 14
 */
public class CustomNamespaceRegistrar {

  private final DomExtensionsRegistrar registrar;
  private final String namespaceKey;

  private CustomNamespaceRegistrar(DomExtensionsRegistrar registrar, String namespaceKey) {
    this.registrar = registrar;
    this.namespaceKey = namespaceKey;
  }

  public static CustomNamespaceRegistrar create(DomExtensionsRegistrar registrar, String namespaceKey) {
    return new CustomNamespaceRegistrar(registrar, namespaceKey);
  }

  public CustomNamespaceRegistrar add(final String xmlTagName, final Class<? extends DomElement> domElementClass) {
    registrar.registerCollectionChildrenExtension(new XmlName(xmlTagName, namespaceKey), domElementClass);
    return this;
  }

  public CustomNamespaceRegistrar addFixed(final String xmlTagName, final Class<? extends DomElement> domElementClass) {
    registrar.registerFixedNumberChildExtension(new XmlName(xmlTagName, namespaceKey), domElementClass);
    return this;
  }
}
