/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.sql.script;

import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;

/**
 * @author gregsh
 */
public abstract class SqlReader {

  public static final Key<Long> PART_OFFSET = Key.create("PART_OFFSET");
  public static final Key<Integer> PART_INDEX = Key.create("PART_INDEX");
  public static final Key<Integer> PART_ERRORS = Key.create("PART_ERRORS");

  @NotNull
  public abstract SqlFile getReadOnlyPsi(@NotNull SqlLanguageDialect language,
                                         @NotNull CharSequence text);

  @NotNull
  public abstract SyntaxTraverser<LighterASTNode> parseSql(@NotNull SqlLanguageDialect language,
                                                           @NotNull CharSequence text);

  public abstract JBIterable<SyntaxTraverser<LighterASTNode>> parseSql(@NotNull SqlLanguageDialect language,
                                                                       @NotNull VirtualFile virtualFile,
                                                                       @NotNull Disposable disposable);
}
