package com.intellij.database.psi;

import com.intellij.database.dataSource.DataSourceTemplate;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;

/**
 * @author Gregory.Shrago
 */
public abstract class DbPsiManager {
  public abstract List<DbDataSource> getDataSources();

  public abstract void removeDataSource(DbDataSource element);

  @NotNull
  public abstract Configurable createDataSourceEditor(DbDataSource template);

  @NotNull
  public abstract List<DataSourceTemplate> getDataSourceTemplates();

  @Nullable
  public abstract DataSourceTemplate getDataSourceTemplate(DbDataSource element);

  public abstract boolean canCreateDataSourceByFiles(Collection<VirtualFile> files);

  @NotNull
  public abstract Collection<DbDataSource> createDataSourceByFiles(Collection<VirtualFile> files);

  public abstract void fireDataSourceUpdated(DbDataSource element);
}
