var pluginFactories: {
    [name: string]: () => LanguagePluginFactory
} = {
    typescript(): LanguagePluginFactory {
        var tsFactory = require("./typescript/ts-plugin");
        return tsFactory.typescriptLanguagePluginFactory;
    }

}

let initializedPlugin: LanguagePlugin = null;


function parseParams(): {
    sessionId: string,
    restArgs: string,
    pluginName: string
    [p: string]: any
} {
    let result: {
        sessionId: string,
        restArgs: any,
        pluginName: string
        [p: string]: any
    } = {
        sessionId: null,
        restArgs: null,
        pluginName: null
    };
    let args = process.argv.slice(2);
    let counter = 0;

    let paramNameToPropertyName: any = {};
    paramNameToPropertyName["-id="] = 'sessionId';
    paramNameToPropertyName["-pluginName="] = 'pluginName';

    args.forEach(function (value, index, arr) {
        function isName(name: string) {
            return value.indexOf(name) === 0;
        }

        function getValue() {
            return value.split('=')[1];
        }

        Object.keys(paramNameToPropertyName).forEach(function (val) {
            if (isName(val)) {
                result[paramNameToPropertyName[val]] = getValue();
                counter++;
            }
        })
    });

    result.restArgs = args.slice(counter);

    return result;
}

function initAndStartListening(params: {
    sessionId: string,
    restArgs: string,
    pluginName: string}) {
    const readline: NodeJS.ReadLine = require("readline");

    const rl = readline.createInterface({
        input: process.stdin,
        output: process.stdout,
        terminal: false,
    });

    //I am not sure that we need it
    process.stdin.setEncoding('utf8');


    let expectedState: boolean = true;

    rl.on("line", (input: string) => {
        const message = input.trim();
        if (expectedState) {
            let state: PluginState = JSON.parse(message);
            if (state && state.pluginName) {
                const pluginName = state.pluginName;
                if (initializedPlugin == null) {
                    let pluginFactory = pluginFactories[pluginName]();
                    if (pluginFactory != null) {
                        let result: {success?: boolean, error?: string, message?: any, stack?: any } = {}

                        try {
                            let {languagePlugin, readyMessage} = pluginFactory.create(state);
                            initializedPlugin = languagePlugin;
                            result.success = true;
                            result.message = readyMessage;

                            sendJson(JSON.stringify(result));
                        } catch (e) {
                            //initialization error
                            //ok, lets kill the process
                            result.success = false;
                            let err = e.message || e.messageText;
                            result.error = "Initialization error (" + pluginName + "). " + err;
                            result.stack = e.stack;
                            sendJson(JSON.stringify(result));
                        }
                    }
                }
                expectedState = false;
            }
        } else {
            if (initializedPlugin != null) {
                try {
                    initializedPlugin.onMessage(message);
                } catch (e) {
                    console.error(e.message + " " + e.stack);
                }
            }
        }
    });

    rl.on("close", () => {
        exitProcess();
    });

    sendCommand("ready")

    setInterval(() => {
        console.error('Process heartbeat: "alive"');
    }, 60000);

    function sendCommand(command: string) {
        process.stdout.write(params.sessionId + ' ' + command + '\n');
    }

    function sendJson(json: string) {
        process.stdout.write(json + '\n');
    }
}


function exitProcess() {
    process.exit(0);
}

initAndStartListening(parseParams());


