package com.intellij.psi.css;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nullable;

/**
 * Psi file that represents all kind of stylesheet files like CSS, LESS, SASS etc.
 */
public interface StylesheetFile extends PsiFile {
  StylesheetFile[] EMPTY_ARRAY = new StylesheetFile[0];

  CssStylesheet getStylesheet();

  boolean isImportVisibleInContext(CssImport anImport, @Nullable PsiElement context);
}
