/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.psi.css;

import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public interface CssStylesheet extends CssElement {
  @NotNull
  CssNamespace[] getNamespaces();
  
  @Nullable
  CssNamespace getNamespace(@Nullable String prefix);
  
  /**
   * @return at rules from current and all imported files, that declared in 'screen' media. 
   * Use {@link this#getRulesetList()} to collect elements from current stylesheet only.
   */
  @NotNull
  CssAtRule[] getAtRules();
  
  /**
   * @return rulesets from current and all imported files, that declared in 'screen' media
   * Use {@link this#getRulesetList()} to collect elements from current stylesheet only.
   */
  @NotNull
  CssRuleset[] getRulesets();

  /**
   * @param allMedias If false then only 'screen' rulesets would be return, otherwise – all rulesets
   * @return rulesets from current and all imported files
   * Use {@link this#getRulesetList()} to collect elements from current stylesheet only.
   */
  @NotNull
  CssRuleset[] getRulesets(boolean allMedias);

  @NotNull
  CssRulesetList getRulesetList();

  @NotNull
  List<CssImport> getImports();

  @NotNull
  List<CssImport> getImports(boolean fromImportListOnly);

  @Nullable
  CssRuleset addRuleset(@NotNull CssRuleset ruleset) throws IncorrectOperationException;

  @Nullable
  CssCharset getCharset();

  @Nullable
  CssImportList getImportList();
}
