package com.intellij.ws.rest;

import com.sun.jersey.api.core.ClasspathResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.server.impl.modelapi.annotation.IntrospectionModeller;
import com.sun.jersey.server.wadl.WadlBuilder;
import com.sun.jersey.server.wadl.WadlGeneratorImpl;
import com.sun.research.ws.wadl.Application;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;


/**
 * @author Konstantin Bulenkov
 */
public class GenerateWadlFromJava {
    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.out.println("Wadl2Java wrapper by Konstantin Bulenkov (konstantin@bulenkov.com)");
            System.out.println("Usage:");
            System.out.println("\t\tjava GenerateWadlFromJava <path_to_application> <Base_URI> <WADL_file_name>");
            return;
        }
        String classpath = args[0];
        String baseUri = args[1];
        String wadlFile = args[2];

        Application a = createApplication(new String[]{classpath});
      for (com.sun.research.ws.wadl.Resources resources : a.getResources()) {
        resources.setBase(baseUri);
      }
        JAXBContext c = JAXBContext.newInstance("com.sun.research.ws.wadl", GenerateWadlFromJava.class.getClassLoader());
        Marshaller m = c.createMarshaller();
        OutputStream out = new BufferedOutputStream(new FileOutputStream(wadlFile));
        m.marshal(a, out);
        out.close();
    }

    private static Application createApplication(String[] paths) {
        final ClassLoader cl = Thread.currentThread().getContextClassLoader();
        final ClassLoader ncl = new Loader(paths, GenerateWadlFromJava.class.getClassLoader());
        Thread.currentThread().setContextClassLoader(ncl);
        try {
            ResourceConfig rc = new ClasspathResourceConfig(paths);
            Set<AbstractResource> s = new HashSet<AbstractResource>();
            for (Class c : rc.getRootResourceClasses()) {
                s.add(IntrospectionModeller.createResource(c));
            }
            return new WadlBuilder(new WadlGeneratorImpl()).generate(s).getApplication();
        } catch (Exception e) {
            throw new RuntimeException(e);
        } finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private static class Loader extends URLClassLoader {
        Loader(String[] paths, ClassLoader parent) {
            super(getURLs(paths), parent);
        }

        Loader(String[] paths) {
            super(getURLs(paths));
        }

        @Override
        public Class findClass(String name) throws ClassNotFoundException {
            return super.findClass(name);
        }

        private static URL[] getURLs(String[] paths) {
            List<URL> urls = new ArrayList<URL>();
            for (String path : paths) {
                try {
                    urls.add(new File(path).toURI().toURL());
                } catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }

            return urls.toArray(new URL[urls.size()]);
        }
    }
}
