/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializedResourcePathsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\u000f\u001a\u00020\u0004*\u00020\u000bH\u0002J\f\u0010\u0010\u001a\u00020\u0004*\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/serialization/js/KotlinJavascriptSerializedResourcePaths;", "", "()V", "CLASSES_FILE_EXTENSION", "", "STRING_TABLE_FILE_EXTENSION", "getClassMetadataPath", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassesInPackageFilePath", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getPackageFilePath", "getStringTableFilePath", "shortName", "toPath", "withSepIfNotEmpty", "js.serializer"})
public final class KotlinJavascriptSerializedResourcePaths {
    private static final String CLASSES_FILE_EXTENSION = "kotlin_classes";
    private static final String STRING_TABLE_FILE_EXTENSION = "kotlin_string_table";
    public static final KotlinJavascriptSerializedResourcePaths INSTANCE;

    @NotNull
    public final String getClassesInPackageFilePath(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        return this.withSepIfNotEmpty(this.toPath(fqName2)) + this.shortName(fqName2) + "." + CLASSES_FILE_EXTENSION;
    }

    @NotNull
    public final String getClassMetadataPath(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        return this.withSepIfNotEmpty(this.toPath(classId.getPackageFqName())) + classId.getRelativeClassName().asString() + "." + KotlinJavascriptSerializationUtil.INSTANCE.getCLASS_METADATA_FILE_EXTENSION();
    }

    @NotNull
    public final String getPackageFilePath(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        return this.toPath(KotlinJavascriptSerializedResourcePathsKt.access$getPackageClassFqName(fqName2)) + "." + KotlinJavascriptSerializationUtil.INSTANCE.getCLASS_METADATA_FILE_EXTENSION();
    }

    @NotNull
    public final String getStringTableFilePath(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        return this.withSepIfNotEmpty(this.toPath(fqName2)) + this.shortName(fqName2) + "." + STRING_TABLE_FILE_EXTENSION;
    }

    private final String toPath(@NotNull FqName $receiver) {
        return StringsKt.replace$default((String)$receiver.asString(), (char)'.', (char)'/', (boolean)false, (int)4, null);
    }

    private final String withSepIfNotEmpty(@NotNull String $receiver) {
        CharSequence charSequence = $receiver;
        return charSequence.length() == 0 ? $receiver : $receiver + "/";
    }

    private final String shortName(FqName fqName2) {
        String string;
        if (fqName2.isRoot()) {
            string = "default-package";
        } else {
            String string2 = fqName2.shortName().asString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fqName.shortName().asString()");
        }
        return string;
    }

    private KotlinJavascriptSerializedResourcePaths() {
        INSTANCE = this;
        CLASSES_FILE_EXTENSION = CLASSES_FILE_EXTENSION;
        STRING_TABLE_FILE_EXTENSION = STRING_TABLE_FILE_EXTENSION;
    }

    static {
        new KotlinJavascriptSerializedResourcePaths();
    }
}

