/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.PackageQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.TypeParameterQualifier;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\"\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"resolveQualifierAsReceiverInExpression", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "qualifier", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Qualifier;", "selector", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "resolveQualifierAsStandaloneExpression", "resolveQualifierReferenceTarget", "frontend"})
public final class QualifiedExpressionResolveUtilKt {
    @NotNull
    public static final DeclarationDescriptor resolveQualifierAsReceiverInExpression(@NotNull Qualifier qualifier, @Nullable DeclarationDescriptor selector, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)qualifier, (String)"qualifier");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        DeclarationDescriptor referenceTarget = QualifiedExpressionResolveUtilKt.resolveQualifierReferenceTarget(qualifier, selector, context);
        if (referenceTarget instanceof TypeParameterDescriptor) {
            context.trace.report(Errors.TYPE_PARAMETER_ON_LHS_OF_DOT.on((KtSimpleNameExpression)((PsiElement)qualifier.getReferenceExpression()), (TypeParameterDescriptor)referenceTarget));
        }
        return referenceTarget;
    }

    @NotNull
    public static final DeclarationDescriptor resolveQualifierAsStandaloneExpression(@NotNull Qualifier qualifier, @NotNull ExpressionTypingContext context) {
        DeclarationDescriptor referenceTarget;
        Intrinsics.checkParameterIsNotNull((Object)qualifier, (String)"qualifier");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        DeclarationDescriptor declarationDescriptor = referenceTarget = QualifiedExpressionResolveUtilKt.resolveQualifierReferenceTarget(qualifier, null, context);
        if (declarationDescriptor instanceof TypeParameterDescriptor) {
            context.trace.report(Errors.TYPE_PARAMETER_IS_NOT_AN_EXPRESSION.on((KtSimpleNameExpression)((PsiElement)qualifier.getReferenceExpression()), (TypeParameterDescriptor)referenceTarget));
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            if (!((ClassDescriptor)referenceTarget).getKind().isSingleton()) {
                context.trace.report(Errors.NO_COMPANION_OBJECT.on((KtSimpleNameExpression)((PsiElement)qualifier.getReferenceExpression()), (ClassifierDescriptor)referenceTarget));
            }
        } else if (declarationDescriptor instanceof PackageViewDescriptor) {
            context.trace.report(Errors.EXPRESSION_EXPECTED_PACKAGE_FOUND.on((KtSimpleNameExpression)((PsiElement)qualifier.getReferenceExpression())));
        }
        return referenceTarget;
    }

    private static final DeclarationDescriptor resolveQualifierReferenceTarget(Qualifier qualifier, DeclarationDescriptor selector, ExpressionTypingContext context) {
        DeclarationDescriptor selectorContainer;
        DeclarationDescriptor declarationDescriptor;
        if (qualifier instanceof TypeParameterQualifier) {
            return ((TypeParameterQualifier)qualifier).getDescriptor();
        }
        DeclarationDescriptor declarationDescriptor2 = selector;
        if (declarationDescriptor2 instanceof ConstructorDescriptor) {
            declarationDescriptor = ((ConstructorDescriptor)selector).getContainingDeclaration().getContainingDeclaration();
        } else {
            DeclarationDescriptor declarationDescriptor3 = selector;
            declarationDescriptor = selectorContainer = declarationDescriptor3 != null ? declarationDescriptor3.getContainingDeclaration() : null;
        }
        if (qualifier instanceof PackageQualifier && (selectorContainer instanceof PackageFragmentDescriptor || selectorContainer instanceof PackageViewDescriptor) && Intrinsics.areEqual((Object)DescriptorUtils.getFqName(((PackageQualifier)qualifier).getDescriptor()), (Object)DescriptorUtils.getFqName(selectorContainer))) {
            return ((PackageQualifier)qualifier).getDescriptor();
        }
        if (qualifier instanceof ClassQualifier) {
            ClassDescriptor classifier2 = ((ClassQualifier)qualifier).getDescriptor();
            boolean selectorIsCallable = selector instanceof CallableDescriptor && (((CallableDescriptor)selector).getDispatchReceiverParameter() != null || ((CallableDescriptor)selector).getExtensionReceiverParameter() != null);
            ClassDescriptor classValueDescriptor = DescriptorUtilsKt.getClassValueDescriptor(classifier2);
            if (selectorIsCallable && classValueDescriptor != null) {
                ClassDescriptor classDescriptor = DescriptorUtilsKt.getClassValueTypeDescriptor(classifier2);
                if (classDescriptor == null) {
                    Intrinsics.throwNpe();
                }
                ClassDescriptor classValueTypeDescriptor = classDescriptor;
                context.trace.record(BindingContext.REFERENCE_TARGET, qualifier.getReferenceExpression(), classValueDescriptor);
                context.trace.recordType(QualifierKt.getExpression(qualifier), classValueTypeDescriptor.getDefaultType());
                if (DescriptorUtilsKt.getHasCompanionObject(classifier2)) {
                    context.trace.record(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, qualifier.getReferenceExpression(), classifier2);
                }
                return classValueTypeDescriptor;
            }
        }
        return qualifier.getDescriptor();
    }
}

