/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature.ui;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.StringTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.util.ui.ColumnInfo;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinCallableParameterTableModel;

public class KotlinFunctionParameterTableModel
extends KotlinCallableParameterTableModel {
    public KotlinFunctionParameterTableModel(KotlinMethodDescriptor methodDescriptor, PsiElement typeContext, PsiElement defaultValueContext) {
        super(methodDescriptor, typeContext, defaultValueContext, new ColumnInfo[]{new ParameterTableModelBase.NameColumn(typeContext.getProject()), new ParameterTableModelBase.TypeColumn(typeContext.getProject(), (FileType)KotlinFileType.INSTANCE), new ParameterTableModelBase.DefaultValueColumn(typeContext.getProject(), (FileType)KotlinFileType.INSTANCE), new ReceiverColumn(typeContext.getProject(), methodDescriptor)});
    }

    public void removeRow(int idx) {
        if (((ParameterTableModelItemBase)this.getRowValue((int)idx)).parameter == this.getReceiver()) {
            this.setReceiver(null);
        }
        super.removeRow(idx);
    }

    @Override
    @Nullable
    public KotlinParameterInfo getReceiver() {
        return ((ReceiverColumn)this.getColumnInfos()[this.getColumnCount() - 1]).receiver;
    }

    public void setReceiver(@Nullable KotlinParameterInfo receiver) {
        ((ReceiverColumn)this.getColumnInfos()[this.getColumnCount() - 1]).receiver = receiver;
    }

    public static boolean isReceiverColumn(ColumnInfo column) {
        return column instanceof ReceiverColumn;
    }

    protected static class ReceiverColumn<TableItem extends ParameterTableModelItemBase<KotlinParameterInfo>>
    extends ParameterTableModelBase.ColumnInfoBase<KotlinParameterInfo, TableItem, Boolean> {
        private final Project project;
        @Nullable
        private KotlinParameterInfo receiver;

        public ReceiverColumn(Project project, @Nullable KotlinMethodDescriptor methodDescriptor) {
            super("Receiver:");
            this.project = project;
            this.receiver = methodDescriptor != null ? methodDescriptor.getReceiver() : null;
        }

        public Boolean valueOf(TableItem item) {
            return ((ParameterTableModelItemBase)item).parameter == this.receiver;
        }

        public void setValue(TableItem item, Boolean value2) {
            if (value2 == null) {
                return;
            }
            this.receiver = value2 != false ? (KotlinParameterInfo)((ParameterTableModelItemBase)item).parameter : null;
        }

        public boolean isCellEditable(TableItem pParameterTableModelItemBase) {
            return true;
        }

        public TableCellRenderer doCreateRenderer(TableItem item) {
            return new BooleanTableCellRenderer();
        }

        public TableCellEditor doCreateEditor(TableItem o) {
            return new StringTableCellEditor(this.project);
        }
    }
}

