/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a\u001e\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001e\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0018"}, d2={"formatClass", "", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "inCode", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "formatClassDescriptor", "formatFunction", "functionDescriptor", "formatFunctionDescriptor", "formatJavaOrLightMethod", "method", "Lcom/intellij/psi/PsiMethod;", "formatPsiClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "markAsJava", "formatPsiMethod", "psiMethod", "showContainingClass", "wrapOrSkip", "s", "idea"})
public final class RenderingUtilsKt {
    @NotNull
    public static final String wrapOrSkip(@NotNull String s, boolean inCode) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        return inCode ? "<code>" + s + "</code>" : s;
    }

    @NotNull
    public static final String formatClassDescriptor(@NotNull DeclarationDescriptor classDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
        return IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.render(classDescriptor);
    }

    @NotNull
    public static final String formatPsiClass(@NotNull PsiClass psiClass2, boolean markAsJava, boolean inCode) {
        Intrinsics.checkParameterIsNotNull((Object)psiClass2, (String)"psiClass");
        String kind2 = psiClass2.isInterface() ? "interface " : "class ";
        String description = kind2 + PsiFormatUtil.formatClass((PsiClass)psiClass2, (int)4355);
        description = RenderingUtilsKt.wrapOrSkip(description, inCode);
        return markAsJava ? "[Java] " + description : description;
    }

    @NotNull
    public static final String formatClass(@NotNull DeclarationDescriptor classDescriptor, boolean inCode) {
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
        PsiElement element2 = DescriptorToSourceUtils.descriptorToDeclaration(classDescriptor);
        return element2 instanceof PsiClass ? RenderingUtilsKt.formatPsiClass((PsiClass)element2, false, inCode) : RenderingUtilsKt.wrapOrSkip(RenderingUtilsKt.formatClassDescriptor(classDescriptor), inCode);
    }

    @NotNull
    public static final String formatFunction(@NotNull DeclarationDescriptor functionDescriptor, boolean inCode) {
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor, (String)"functionDescriptor");
        PsiElement element2 = DescriptorToSourceUtils.descriptorToDeclaration(functionDescriptor);
        return element2 instanceof PsiMethod ? RenderingUtilsKt.formatPsiMethod((PsiMethod)element2, false, inCode) : RenderingUtilsKt.wrapOrSkip(RenderingUtilsKt.formatFunctionDescriptor(functionDescriptor), inCode);
    }

    private static final String formatFunctionDescriptor(DeclarationDescriptor functionDescriptor) {
        return DescriptorRenderer.COMPACT.render(functionDescriptor);
    }

    @NotNull
    public static final String formatPsiMethod(@NotNull PsiMethod psiMethod2, boolean showContainingClass, boolean inCode) {
        String description;
        Intrinsics.checkParameterIsNotNull((Object)psiMethod2, (String)"psiMethod");
        int options2 = 259;
        if (showContainingClass) {
            options2 |= 0x1000;
        }
        String string = description = PsiFormatUtil.formatMethod((PsiMethod)psiMethod2, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options2, (int)2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"description");
        description = RenderingUtilsKt.wrapOrSkip(string, inCode);
        return "[Java] " + description;
    }

    @NotNull
    public static final String formatJavaOrLightMethod(@NotNull PsiMethod method) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        PsiElement originalDeclaration = LightClassUtilsKt.getUnwrapped((PsiElement)method);
        return originalDeclaration instanceof KtDeclaration ? RenderingUtilsKt.formatFunctionDescriptor(ResolutionUtils.resolveToDescriptor((KtDeclaration)originalDeclaration)) : RenderingUtilsKt.formatPsiMethod(method, false, false);
    }

    @NotNull
    public static final String formatClass(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor(classOrObject);
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        return RenderingUtilsKt.formatClassDescriptor((ClassDescriptor)declarationDescriptor);
    }
}

