/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.BranchedFoldingUtils;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTryExpression;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/LiftAssignmentOutOfTryFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "element", "(Lorg/jetbrains/kotlin/psi/KtTryExpression;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "idea"})
public final class LiftAssignmentOutOfTryFix
extends KotlinQuickFixAction<KtTryExpression> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return "Lift assignment out of 'try' expression";
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtBinaryExpression ktBinaryExpression = BranchedFoldingUtils.INSTANCE.getFoldableBranchedAssignment(((KtTryExpression)this.getElement()).getTryBlock());
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression tryAssignment = ktBinaryExpression;
        String op = tryAssignment.getOperationReference().getText();
        Object object = tryAssignment.getLeft();
        if (object == null || (object = object.getText()) == null) {
            return;
        }
        Object leftText = object;
        KtExpression ktExpression = tryAssignment.getRight();
        if (ktExpression == null) {
            return;
        }
        tryAssignment.replace((PsiElement)ktExpression);
        for (KtCatchClause catchClause : ((KtTryExpression)this.getElement()).getCatchClauses()) {
            KtBinaryExpression catchAssignment;
            KtBinaryExpression ktBinaryExpression2 = catchAssignment = BranchedFoldingUtils.INSTANCE.getFoldableBranchedAssignment(catchClause.getCatchBody());
            if (ktBinaryExpression2 == null) continue;
            KtExpression ktExpression2 = catchAssignment.getRight();
            if (ktExpression2 == null) {
                Intrinsics.throwNpe();
            }
            PsiElement psiElement = (PsiElement)ktExpression2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"catchAssignment.right!!");
            ktBinaryExpression2.replace(psiElement);
        }
        KtTryExpression ktTryExpression = (KtTryExpression)this.getElement();
        KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory(this.getElement());
        Object[] objectArray = new Object[3];
        objectArray[0] = leftText;
        String string = op;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"op");
        objectArray[1] = string;
        objectArray[2] = this.getElement();
        ktTryExpression.replace((PsiElement)CreateByPatternKt.createExpressionByPattern(ktPsiFactory, "$0 $1 $2", objectArray));
    }

    public LiftAssignmentOutOfTryFix(@NotNull KtTryExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        super((PsiElement)element2);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/LiftAssignmentOutOfTryFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            PsiElement psiElement;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtExpression)) {
                psiElement2 = null;
            }
            KtExpression ktExpression = (KtExpression)psiElement2;
            if (ktExpression == null) {
                return null;
            }
            KtExpression expression2 = ktExpression;
            PsiElement psiElement3 = expression2.getParent();
            if (!((psiElement3 != null && (psiElement3 = psiElement3.getParent()) != null ? psiElement3.getParent() : (psiElement = null)) instanceof KtCatchClause)) {
                psiElement = null;
            }
            KtCatchClause ktCatchClause = (KtCatchClause)psiElement;
            if (ktCatchClause == null) {
                return null;
            }
            KtCatchClause originalCatch = ktCatchClause;
            PsiElement psiElement4 = originalCatch.getParent();
            if (!(psiElement4 instanceof KtTryExpression)) {
                psiElement4 = null;
            }
            KtTryExpression ktTryExpression = (KtTryExpression)psiElement4;
            if (ktTryExpression == null) {
                return null;
            }
            KtTryExpression tryExpression = ktTryExpression;
            KtBinaryExpression ktBinaryExpression = BranchedFoldingUtils.INSTANCE.getFoldableBranchedAssignment(tryExpression.getTryBlock());
            if (ktBinaryExpression == null) {
                return null;
            }
            KtBinaryExpression tryAssignment = ktBinaryExpression;
            for (KtCatchClause catchClause : tryExpression.getCatchClauses()) {
                KtBinaryExpression catchAssignment;
                if (BranchedFoldingUtils.INSTANCE.getFoldableBranchedAssignment(catchClause.getCatchBody()) == null) {
                    return null;
                }
                if (BranchedFoldingUtils.INSTANCE.checkAssignmentsMatch(tryAssignment, catchAssignment)) continue;
                return null;
            }
            return new LiftAssignmentOutOfTryFix(tryExpression);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

