/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.branchedTransformations.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.BranchedFoldingUtils;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/branchedTransformations/intentions/FoldWhenToAssignmentIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "idea"})
public final class FoldWhenToAssignmentIntention
extends SelfTargetingRangeIntention<KtWhenExpression> {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtWhenExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (!KtPsiUtil.checkWhenExpressionHasSingleElse(element2)) {
            return null;
        }
        List<KtWhenEntry> entries2 = element2.getEntries();
        if (entries2.isEmpty()) {
            return null;
        }
        ArrayList<KtBinaryExpression> assignments = new ArrayList<KtBinaryExpression>();
        for (KtWhenEntry entry : entries2) {
            KtBinaryExpression assignment;
            if (BranchedFoldingUtils.INSTANCE.getFoldableBranchedAssignment(entry.getExpression()) == null) {
                return null;
            }
            assignments.add(assignment);
        }
        boolean entry = !assignments.isEmpty();
        if (_Assertions.ENABLED && !entry) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KtBinaryExpression firstAssignment = (KtBinaryExpression)CollectionsKt.first((List)assignments);
        Iterator iterator2 = assignments.iterator();
        while (iterator2.hasNext()) {
            KtBinaryExpression assignment;
            KtBinaryExpression ktBinaryExpression = assignment = (KtBinaryExpression)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktBinaryExpression, (String)"assignment");
            if (BranchedFoldingUtils.INSTANCE.checkAssignmentsMatch(ktBinaryExpression, firstAssignment)) continue;
            return null;
        }
        return element2.getWhenKeyword().getTextRange();
    }

    @Override
    public void applyTo(@NotNull KtWhenExpression element2, @Nullable Editor editor) {
        KtExpression assignment;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        boolean bl = !element2.getEntries().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KtExpression ktExpression = ((KtWhenEntry)CollectionsKt.first(element2.getEntries())).getExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtBinaryExpression ktBinaryExpression = BranchedFoldingUtils.INSTANCE.getFoldableBranchedAssignment(ktExpression);
        if (ktBinaryExpression == null) {
            Intrinsics.throwNpe();
        }
        KtBinaryExpression firstAssignment = ktBinaryExpression;
        String op = firstAssignment.getOperationReference().getText();
        KtExpression ktExpression2 = firstAssignment.getLeft();
        if (ktExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNameReferenceExpression");
        }
        KtNameReferenceExpression lhs = (KtNameReferenceExpression)ktExpression2;
        KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)element2);
        Object[] objectArray = new Object[3];
        objectArray[0] = lhs;
        String string = op;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"op");
        objectArray[1] = string;
        objectArray[2] = element2;
        KtExpression ktExpression3 = assignment = CreateByPatternKt.createExpressionByPattern(ktPsiFactory, "$0 $1 $2", objectArray);
        if (ktExpression3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        KtExpression ktExpression4 = ((KtBinaryExpression)ktExpression3).getRight();
        if (ktExpression4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenExpression");
        }
        KtWhenExpression newWhenExpression = (KtWhenExpression)ktExpression4;
        for (KtWhenEntry entry : newWhenExpression.getEntries()) {
            KtExpression currRhs;
            KtBinaryExpression currAssignment;
            KtExpression ktExpression5 = entry.getExpression();
            if (ktExpression5 == null) {
                Intrinsics.throwNpe();
            }
            if (BranchedFoldingUtils.INSTANCE.getFoldableBranchedAssignment(ktExpression5) == null) {
                Intrinsics.throwNpe();
            }
            if (currAssignment.getRight() == null) {
                Intrinsics.throwNpe();
            }
            PsiElement psiElement = (PsiElement)currRhs;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"currRhs");
            currAssignment.replace(psiElement);
        }
        element2.replace((PsiElement)assignment);
    }

    public FoldWhenToAssignmentIntention() {
        super(KtWhenExpression.class, "Lift assignment out of 'when' expression", null, 4, null);
    }
}

