/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CharIterator;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0014\u0010\u0010\u001a\n \u0011*\u0004\u0018\u00010\u000b0\u000b*\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ToRawStringLiteralIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "convertContent", "", "hasTrailingSpaces", "", "text", "isApplicableTo", "value", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "idea"})
public final class ToRawStringLiteralIntention
extends SelfTargetingOffsetIndependentIntention<KtStringTemplateExpression>
implements LowPriorityAction {
    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isApplicableTo(@NotNull KtStringTemplateExpression element2) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        String text2 = element2.getText();
        if (StringsKt.startsWith$default((String)text2, (String)"\"\"\"", (boolean)false, (int)2, null)) {
            return false;
        }
        Object[] objectArray = element2.getEntries();
        Iterator iterator2 = $receiver$iv;
        Collection collection = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            if (!(element$iv$iv instanceof KtEscapeStringTemplateEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List escapeEntries = (List)destination$iv$iv;
        for (KtEscapeStringTemplateEntry entry : escapeEntries) {
            Character c = StringsKt.singleOrNull((CharSequence)entry.getUnescapedValue());
            if (c == null) {
                return false;
            }
            char c2 = c.charValue();
            if (!Character.isISOControl(c2) || c2 == '\n' || c2 == '\r') continue;
            return false;
        }
        String converted = this.convertContent(element2);
        return !StringsKt.contains$default((CharSequence)converted, (CharSequence)"\"\"\"", (boolean)false, (int)2, null) && !this.hasTrailingSpaces(converted);
    }

    @Override
    public void applyTo(@NotNull KtStringTemplateExpression element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        String text2 = this.convertContent(element2);
        element2.replace((PsiElement)KtPsiFactoryKt.KtPsiFactory((PsiElement)element2).createExpression("\"\"\"" + text2 + "\"\"\""));
    }

    /*
     * WARNING - void declaration
     */
    private final String convertContent(KtStringTemplateExpression element2) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder;
        KtStringTemplateEntry[] entries2 = element2.getEntries();
        for (IndexedValue indexedValue : ArraysKt.withIndex((Object[])entries2)) {
            void $receiver;
            int index2 = indexedValue.component1();
            KtStringTemplateEntry entry = (KtStringTemplateEntry)indexedValue.component2();
            String value2 = this.value(entry);
            if (StringsKt.endsWith$default((String)value2, (String)"$", (boolean)false, (int)2, null) && index2 < ((Object[])entries2).length - 1) {
                char nextChar;
                char c = nextChar = StringsKt.first((CharSequence)this.value(entries2[index2 + 1]));
                if (Character.isJavaIdentifierStart(c) || nextChar == '{') {
                    $receiver.append("${\"$\"}");
                    continue;
                }
            }
            $receiver.append(value2);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String text2 = string;
        String string2 = StringUtilRt.convertLineSeparators((String)text2, (String)"\n");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtilRt.convertLineSeparators(text, \"\\n\")");
        return string2;
    }

    private final boolean hasTrailingSpaces(String text2) {
        boolean afterSpace = true;
        CharIterator charIterator = StringsKt.iterator((CharSequence)text2);
        while (charIterator.hasNext()) {
            char c = charIterator.nextChar();
            if ((c == '\n' || c == '\r') && afterSpace) {
                return true;
            }
            afterSpace = c == ' ' || c == '\t';
        }
        return false;
    }

    private final String value(@NotNull KtStringTemplateEntry $receiver) {
        return $receiver instanceof KtEscapeStringTemplateEntry ? ((KtEscapeStringTemplateEntry)$receiver).getUnescapedValue() : $receiver.getText();
    }

    public ToRawStringLiteralIntention() {
        super(KtStringTemplateExpression.class, "To raw string literal", null, 4, null);
    }
}

