/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.ConvertPrimaryConstructorToSecondaryIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u00020\n*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\r\u001a\u00020\n*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertPrimaryConstructorToSecondaryIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "isIndependent", "Lorg/jetbrains/kotlin/psi/KtProperty;", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "idea"})
public final class ConvertPrimaryConstructorToSecondaryIntention
extends SelfTargetingIntention<KtPrimaryConstructor> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableTo(@NotNull KtPrimaryConstructor element2, int caretOffset) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (!(KtPsiUtilKt.getContainingClassOrObject(element2) instanceof KtClass)) return false;
        Iterable $receiver$iv = element2.getValueParameters();
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            KtParameter it = (KtParameter)element$iv;
            if (it.hasValOrVar()) {
                if (!it.getAnnotationEntries().isEmpty()) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    private final boolean isIndependent(@NotNull KtReferenceExpression $receiver, ClassDescriptor classDescriptor, BindingContext context) {
        boolean bl;
        DeclarationDescriptor referencedDescriptor;
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)context.get(BindingContext.REFERENCE_TARGET, $receiver);
        if (declarationDescriptor == null) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor2 = referencedDescriptor = declarationDescriptor;
        if (declarationDescriptor2 instanceof ValueParameterDescriptor) {
            CallableDescriptor callableDescriptor = ((ValueParameterDescriptor)referencedDescriptor).getContainingDeclaration();
            if (!(callableDescriptor instanceof ConstructorDescriptor)) {
                callableDescriptor = null;
            }
            ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)callableDescriptor;
            bl = Intrinsics.areEqual((Object)(constructorDescriptor != null ? constructorDescriptor.getContainingDeclaration() : null), (Object)classDescriptor) ^ true;
        } else {
            bl = SequencesKt.contains(DescriptorUtilsKt.getParents(referencedDescriptor), (Object)classDescriptor) ^ true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isIndependent(@NotNull KtProperty $receiver, KtClass klass2, BindingContext context) {
        void result$iv$iv$iv;
        void predicate$iv;
        void $receiver$iv$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        KtExpression ktExpression = $receiver.getInitializer();
        if (ktExpression == null) {
            return true;
        }
        KtExpression propertyInitializer = ktExpression;
        ClassDescriptor classDescriptor = (ClassDescriptor)context.get(BindingContext.CLASS, klass2);
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        PsiElement psiElement = (PsiElement)propertyInitializer;
        Function1 function1 = (Function1)new Function1<KtReferenceExpression, Boolean>(this, classDescriptor2, context){
            final /* synthetic */ ConvertPrimaryConstructorToSecondaryIntention this$0;
            final /* synthetic */ ClassDescriptor $classDescriptor;
            final /* synthetic */ BindingContext $context;

            public final boolean invoke(@NotNull KtReferenceExpression it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ClassDescriptor classDescriptor = this.$classDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"classDescriptor");
                return !ConvertPrimaryConstructorToSecondaryIntention.access$isIndependent(this.this$0, it, classDescriptor, this.$context);
            }
            {
                this.this$0 = convertPrimaryConstructorToSecondaryIntention;
                this.$classDescriptor = classDescriptor;
                this.$context = bindingContext2;
                super(1);
            }
        };
        void var8_8 = $receiver$iv;
        void var9_9 = $receiver$iv$iv;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        $receiver$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((Function1)predicate$iv, (Ref.ObjectRef)result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;

            public void visitElement(PsiElement element2) {
                if (element2 instanceof KtReferenceExpression && ((Boolean)this.$predicate.invoke((Object)element2)).booleanValue()) {
                    this.$result.element = element2;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element2;
                if (true) {
                    super.visitElement(element2);
                }
            }
            {
                this.$predicate = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }
        });
        return !((PsiElement)result$iv$iv$iv.element != null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtPrimaryConstructor element2, @Nullable Editor editor) {
        KtClass anchorAfter$iv;
        KtSecondaryConstructor ktSecondaryConstructor;
        KtSecondaryConstructor this_$iv;
        KtSecondaryConstructor anchor$iv;
        void destination$iv$iv;
        void $receiver$iv$iv;
        Collection $receiver$iv;
        void destination$iv$iv2;
        Iterable $receiver$iv$iv2;
        void $receiver$iv2;
        void destination$iv$iv3;
        Object element$iv$iv2;
        Iterable $receiver$iv$iv3;
        void $receiver$iv3;
        Object vararg;
        String annotations2;
        PsiElement $receiver;
        Object it;
        KtPsiFactory.CallableBuilder initializer2;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(element2);
        if (!(ktClassOrObject instanceof KtClass)) {
            ktClassOrObject = null;
        }
        KtClass ktClass = (KtClass)ktClassOrObject;
        if (ktClass == null) {
            return;
        }
        KtClass klass2 = ktClass;
        BindingContext context = ResolutionUtils.analyze$default(klass2, null, 1, null);
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory(klass2);
        CommentSaver commentSaver = new CommentSaver(element2, false, 2, null);
        Map initializerMap = MapsKt.mutableMapOf((Pair[])new Pair[0]);
        for (KtProperty property2 : klass2.getProperties()) {
            String string;
            if (this.isIndependent(property2, klass2, context)) continue;
            if (property2.getTypeReference() == null) {
                new SpecifyTypeExplicitlyIntention().applyTo(property2, editor);
            }
            if (property2.getInitializer() == null) {
                Intrinsics.throwNpe();
            }
            object = initializerMap;
            Intrinsics.checkExpressionValueIsNotNull((Object)initializer2.getText(), (String)"initializer.text");
            object.put(property2, string);
            initializer2.delete();
            PsiElement psiElement = property2.getEqualsToken();
            if (psiElement == null) {
                Intrinsics.throwNpe();
            }
            psiElement.delete();
        }
        Object object2 = new KtPsiFactory.CallableBuilder(KtPsiFactory.CallableBuilder.Target.CONSTRUCTOR);
        KtPsiFactory ktPsiFactory = factory2;
        initializer2 = (KtPsiFactory.CallableBuilder)object2;
        KtModifierList ktModifierList = element2.getModifierList();
        if (ktModifierList != null) {
            object = ktModifierList;
            it = object;
            String string = it.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.text");
            $receiver.modifier(string);
        }
        KtPsiFactory.CallableBuilder.typeParams$default((KtPsiFactory.CallableBuilder)$receiver, null, 1, null);
        KtPsiFactory.CallableBuilder.name$default((KtPsiFactory.CallableBuilder)$receiver, null, 1, null);
        for (KtParameter valueParameter : element2.getValueParameters()) {
            annotations2 = CollectionsKt.joinToString$default((Iterable)valueParameter.getAnnotationEntries(), (CharSequence)" ", null, null, (int)0, null, (Function1)applyTo.constructor.1.annotations.1.INSTANCE, (int)30, null);
            vararg = valueParameter.isVarArg() ? KtTokens.VARARG_KEYWORD.getValue() : "";
            StringBuilder stringBuilder = new StringBuilder().append(annotations2).append(" ").append((String)vararg).append(" ");
            String string = valueParameter.getName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String string2 = stringBuilder.append(string).toString();
            KtTypeReference ktTypeReference = valueParameter.getTypeReference();
            if (ktTypeReference == null) {
                Intrinsics.throwNpe();
            }
            String string3 = ktTypeReference.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"valueParameter.typeReference!!.text");
            KtExpression ktExpression = valueParameter.getDefaultValue();
            $receiver.param(string2, string3, ktExpression != null ? ktExpression.getText() : null);
        }
        $receiver.noReturnType();
        for (KtSuperTypeListEntry superTypeEntry : klass2.getSuperTypeListEntries()) {
            if (!(superTypeEntry instanceof KtSuperTypeCallEntry)) continue;
            Object object3 = ((KtSuperTypeCallEntry)superTypeEntry).getValueArgumentList();
            if (object3 == null || (object3 = object3.getText()) == null) {
                object3 = "";
            }
            $receiver.superDelegation((String)object3);
            KtTypeReference ktTypeReference = ((KtSuperTypeCallEntry)superTypeEntry).getTypeReference();
            if (ktTypeReference == null) {
                Intrinsics.throwNpe();
            }
            String string = ktTypeReference.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"superTypeEntry.typeReference!!.text");
            superTypeEntry.replace((PsiElement)factory2.createSuperTypeEntry(string));
        }
        it = element2.getValueParameters();
        annotations2 = $receiver$iv3;
        vararg = new ArrayList();
        for (Object element$iv$iv2 : $receiver$iv$iv3) {
            KtParameter it2 = (KtParameter)element$iv$iv2;
            if (!it2.hasValOrVar()) continue;
            destination$iv$iv3.add(element$iv$iv2);
        }
        String valueParameterInitializers2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv3), (CharSequence)"\n", null, null, (int)0, null, (Function1)applyTo.constructor.1.valueParameterInitializers.2.INSTANCE, (int)30, null);
        $receiver$iv$iv3 = klass2.getDeclarations();
        destination$iv$iv3 = $receiver$iv2;
        Collection collection = new ArrayList();
        for (Object element$iv$iv3 : $receiver$iv$iv2) {
            KtDeclaration it3 = (KtDeclaration)element$iv$iv3;
            if (!(it3 instanceof KtProperty && initializerMap.get(it3) != null || it3 instanceof KtAnonymousInitializer)) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        String classBodyInitializers2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<KtDeclaration, CharSequence>(element2, klass2, factory2, initializerMap){
            final /* synthetic */ KtPrimaryConstructor $element$inlined;
            final /* synthetic */ KtClass $klass$inlined;
            final /* synthetic */ KtPsiFactory $factory$inlined;
            final /* synthetic */ Map $initializerMap$inlined;

            public final CharSequence invoke(KtDeclaration it) {
                CharSequence charSequence;
                if (it instanceof KtProperty) {
                    String string = ((KtProperty)it).getName();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    String name2 = string;
                    String text2 = (String)this.$initializerMap$inlined.get(it);
                    charSequence = text2 != null ? KtTokens.THIS_KEYWORD.getValue() + "." + name2 + " = " + text2 : "";
                } else {
                    Object object;
                    KtDeclaration ktDeclaration = it;
                    if (ktDeclaration == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnonymousInitializer");
                    }
                    KtExpression ktExpression = ((KtAnonymousInitializer)ktDeclaration).getBody();
                    if (!(ktExpression instanceof KtBlockExpression)) {
                        ktExpression = null;
                    }
                    charSequence = (object = (KtBlockExpression)ktExpression) != null && (object = ((KtBlockExpression)object).getStatements()) != null && (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"\n", null, null, (int)0, null, (Function1)applyTo.constructor.1.classBodyInitializers.1.INSTANCE, (int)30, null)) != null ? (CharSequence)object : (CharSequence)"";
                }
                return charSequence;
            }
            {
                this.$element$inlined = ktPrimaryConstructor;
                this.$klass$inlined = ktClass;
                this.$factory$inlined = ktPsiFactory;
                this.$initializerMap$inlined = map2;
                super(1);
            }
        }), (int)30, null);
        $receiver$iv$iv2 = CollectionsKt.listOf((Object[])new String[]{valueParameterInitializers2, classBodyInitializers2});
        destination$iv$iv2 = $receiver$iv;
        element$iv$iv2 = new ArrayList();
        for (Object element$iv$iv4 : $receiver$iv$iv) {
            String p1 = (String)element$iv$iv4;
            CharSequence $i$f$filterTo = p1;
            if (!($i$f$filterTo.length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv4);
        }
        List allInitializers = (List)destination$iv$iv;
        $receiver$iv = allInitializers;
        if (!$receiver$iv.isEmpty()) {
            $receiver.blockBody(CollectionsKt.joinToString$default((Iterable)allInitializers, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
        Object object4 = object2;
        KtSecondaryConstructor constructor2 = ktPsiFactory.createSecondaryConstructor(((KtPsiFactory.CallableBuilder)object4).asString());
        object2 = klass2;
        $receiver = null;
        PsiElement psiElement = anchor$iv;
        if (psiElement == null) {
            psiElement = (PsiElement)CollectionsKt.firstOrNull(((KtClassOrObject)((Object)this_$iv)).getDeclarations());
        }
        if (psiElement == null) {
            void this_$iv$iv;
            valueParameterInitializers2 = this_$iv;
            KtClassBody body$iv$iv = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv$iv);
            PsiElement psiElement2 = body$iv$iv.getRBrace();
            if (psiElement2 == null && (psiElement2 = body$iv$iv.getLastChild()) == null) {
                Intrinsics.throwNpe();
            }
            PsiElement anchor$iv$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement2, (Class[])new Class[]{PsiWhiteSpace.class});
            PsiElement psiElement3 = body$iv$iv.addAfter(constructor2, anchor$iv$iv);
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSecondaryConstructor");
            }
            ktSecondaryConstructor = (KtSecondaryConstructor)psiElement3;
        } else {
            anchorAfter$iv = psiElement;
            PsiElement psiElement4 = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)((Object)this_$iv)).addBefore(constructor2, anchorAfter$iv);
            if (psiElement4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSecondaryConstructor");
            }
            ktSecondaryConstructor = (KtSecondaryConstructor)psiElement4;
        }
        this_$iv = ktSecondaryConstructor;
        anchor$iv = this_$iv;
        CommentSaver.restore$default(commentSaver, $receiver, false, 2, null);
        for (KtParameter valueParameter : CollectionsKt.reversed((Iterable)element2.getValueParameters())) {
            void this_$iv2;
            void anchor$iv2;
            if (!valueParameter.hasValOrVar()) continue;
            boolean isVararg = valueParameter.hasModifier(KtTokens.VARARG_KEYWORD);
            valueParameter.removeModifier(KtTokens.VARARG_KEYWORD);
            KtTypeReference ktTypeReference = valueParameter.getTypeReference();
            String typeText = ktTypeReference != null ? ktTypeReference.getText() : null;
            KtModifierList ktModifierList2 = valueParameter.getModifierList();
            String string = ktModifierList2 != null ? ktModifierList2.getText() : null;
            String string4 = valueParameter.getName();
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"valueParameter.name!!");
            KtProperty property3 = factory2.createProperty(string, string4, isVararg && typeText != null ? "Array<out " + typeText + ">" : typeText, valueParameter.isMutable(), null);
            anchorAfter$iv = klass2;
            PsiElement $i$f$addDeclaration = null;
            PsiElement psiElement5 = anchor$iv2;
            if (psiElement5 == null) {
                psiElement5 = (PsiElement)CollectionsKt.firstOrNull(this_$iv2.getDeclarations());
            }
            if (psiElement5 == null) {
                void this_$iv$iv;
                void $i$f$addDeclarationBefore = this_$iv2;
                KtClassBody body$iv$iv = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv$iv);
                PsiElement psiElement6 = body$iv$iv.getRBrace();
                if (psiElement6 == null && (psiElement6 = body$iv$iv.getLastChild()) == null) {
                    Intrinsics.throwNpe();
                }
                PsiElement anchor$iv$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement6, (Class[])new Class[]{PsiWhiteSpace.class});
                PsiElement psiElement7 = body$iv$iv.addAfter(property3, anchor$iv$iv);
                if (psiElement7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
                }
                KtProperty cfr_ignored_0 = (KtProperty)psiElement7;
                continue;
            }
            void anchorAfter$iv2 = psiElement5;
            PsiElement psiElement8 = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv2).addBefore(property3, (PsiElement)anchorAfter$iv2);
            if (psiElement8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
            }
            KtProperty cfr_ignored_1 = (KtProperty)psiElement8;
        }
        for (KtAnonymousInitializer anonymousInitializer : klass2.getAnonymousInitializers()) {
            anonymousInitializer.delete();
        }
        element2.delete();
    }

    public ConvertPrimaryConstructorToSecondaryIntention() {
        super(KtPrimaryConstructor.class, "Convert to secondary constructor", null, 4, null);
    }

    public static final /* synthetic */ boolean access$isIndependent(ConvertPrimaryConstructorToSecondaryIntention $this, @NotNull KtReferenceExpression $receiver, @NotNull ClassDescriptor classDescriptor, @NotNull BindingContext context) {
        return $this.isIndependent($receiver, classDescriptor, context);
    }
}

