/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.RedundantIfInspection$RemoveRedundantIf$WhenMappings;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "RedundantType", "RemoveRedundantIf", "idea"})
public final class RedundantIfInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitIfExpression(@NotNull KtIfExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitIfExpression(expression2);
                if (expression2.getCondition() == null) {
                    return;
                }
                RedundantType type2 = RedundantType.Companion.of$idea(expression2);
                if (Intrinsics.areEqual((Object)((Object)type2), (Object)((Object)RedundantType.NONE))) {
                    return;
                }
                this.$holder.registerProblem((PsiElement)expression2, "Redundant 'if' statement", ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{new RemoveRedundantIf(type2)});
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u0000 \u00062\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$RedundantType;", "", "(Ljava/lang/String;I)V", "NONE", "THEN_TRUE", "ELSE_TRUE", "Companion", "idea"})
    private static final class RedundantType
    extends Enum<RedundantType> {
        public static final /* enum */ RedundantType NONE;
        public static final /* enum */ RedundantType THEN_TRUE;
        public static final /* enum */ RedundantType ELSE_TRUE;
        private static final /* synthetic */ RedundantType[] $VALUES;
        public static final Companion Companion;

        static {
            RedundantType[] redundantTypeArray = new RedundantType[3];
            RedundantType[] redundantTypeArray2 = redundantTypeArray;
            redundantTypeArray[0] = NONE = new RedundantType();
            redundantTypeArray[1] = THEN_TRUE = new RedundantType();
            redundantTypeArray[2] = ELSE_TRUE = new RedundantType();
            $VALUES = redundantTypeArray;
            Companion = new Companion(null);
        }

        public static RedundantType[] values() {
            return (RedundantType[])$VALUES.clone();
        }

        public static RedundantType valueOf(String string) {
            return Enum.valueOf(RedundantType.class, string);
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0002J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$RedundantType$Companion;", "", "()V", "getReturnedExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "of", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$RedundantType;", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "of$idea", "idea"})
        public static final class Companion {
            @NotNull
            public final RedundantType of$idea(@NotNull KtIfExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                KtExpression ktExpression = this.getReturnedExpression(expression2.getThen());
                if (ktExpression == null) {
                    return NONE;
                }
                KtExpression thenReturn = ktExpression;
                KtExpression ktExpression2 = this.getReturnedExpression(expression2.getElse());
                if (ktExpression2 == null) {
                    return NONE;
                }
                KtExpression elseReturn = ktExpression2;
                return KtPsiUtil.isTrueConstant(thenReturn) && KtPsiUtil.isFalseConstant(elseReturn) ? THEN_TRUE : (KtPsiUtil.isFalseConstant(thenReturn) && KtPsiUtil.isTrueConstant(elseReturn) ? ELSE_TRUE : NONE);
            }

            private final KtExpression getReturnedExpression(KtExpression expression2) {
                KtExpression ktExpression;
                KtExpression ktExpression2 = expression2;
                if (ktExpression2 instanceof KtReturnExpression) {
                    ktExpression = ((KtReturnExpression)expression2).getReturnedExpression();
                } else if (ktExpression2 instanceof KtBlockExpression) {
                    Object object = CollectionsKt.singleOrNull(((KtBlockExpression)expression2).getStatements());
                    if (!(object instanceof KtReturnExpression)) {
                        object = null;
                    }
                    KtReturnExpression ktReturnExpression = (KtReturnExpression)object;
                    if (ktReturnExpression == null) {
                        return null;
                    }
                    KtReturnExpression statement = ktReturnExpression;
                    ktExpression = statement.getReturnedExpression();
                } else {
                    ktExpression = null;
                }
                return ktExpression;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$RemoveRedundantIf;", "Lcom/intellij/codeInspection/LocalQuickFix;", "redundantType", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$RedundantType;", "(Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$RedundantType;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    private static final class RemoveRedundantIf
    implements LocalQuickFix {
        private final RedundantType redundantType;

        @NotNull
        public String getName() {
            return "Remove redundant 'if' statement";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            KtExpression ktExpression;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement = descriptor2.getPsiElement();
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
            }
            KtIfExpression element2 = (KtIfExpression)psiElement;
            switch (RedundantIfInspection$RemoveRedundantIf$WhenMappings.$EnumSwitchMapping$0[this.redundantType.ordinal()]) {
                case 1: {
                    return;
                }
                case 2: {
                    ktExpression = element2.getCondition();
                    if (ktExpression != null) break;
                    Intrinsics.throwNpe();
                    break;
                }
                case 3: {
                    KtExpression ktExpression2 = element2.getCondition();
                    if (ktExpression2 == null) {
                        Intrinsics.throwNpe();
                    }
                    ktExpression = UtilsKt.negate(ktExpression2);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            KtExpression condition2 = ktExpression;
            KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)element2);
            Object[] objectArray = new Object[1];
            String string = condition2.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"condition.text");
            objectArray[0] = string;
            element2.replace((PsiElement)CreateByPatternKt.createExpressionByPattern(ktPsiFactory, "return $0", objectArray));
        }

        public RemoveRedundantIf(@NotNull RedundantType redundantType) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)redundantType), (String)"redundantType");
            this.redundantType = redundantType;
        }
    }
}

