/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy.calls;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.call.CallHierarchyNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.hierarchy.calls.KotlinCallHierarchyNodeDescriptor;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

public abstract class KotlinCallTreeStructure
extends HierarchyTreeStructure {
    protected final String scopeType;
    private static final Function1<PsiElement, Boolean> IS_NON_LOCAL_DECLARATION = new Function1<PsiElement, Boolean>(){

        public Boolean invoke(@javax.annotation.Nullable PsiElement input) {
            return input instanceof PsiMethod || (input instanceof KtNamedFunction || input instanceof KtClassOrObject || input instanceof KtProperty) && !KtPsiUtil.isLocal((KtNamedDeclaration)input);
        }
    };

    public KotlinCallTreeStructure(@NotNull Project project, PsiElement element2, String scopeType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallTreeStructure", "<init>"));
        }
        super(project, KotlinCallTreeStructure.createNodeDescriptor(project, element2, null, false, false));
        this.scopeType = scopeType;
    }

    protected static KtElement getEnclosingElementForLocalDeclaration(PsiElement element2) {
        return element2 instanceof KtNamedDeclaration ? KtPsiUtil.getEnclosingElementForLocalDeclaration((KtNamedDeclaration)element2) : null;
    }

    @Nullable
    private static HierarchyNodeDescriptor createNodeDescriptor(Project project, PsiElement element2, HierarchyNodeDescriptor parent2, boolean navigateToReference, boolean wrapAsLightElements) {
        PsiElement nodeElement = element2;
        if (wrapAsLightElements && element2 instanceof KtElement) {
            nodeElement = (PsiElement)CollectionsKt.firstOrNull(LightClassUtilsKt.toLightElements((KtElement)element2));
        }
        if (nodeElement == null) {
            return null;
        }
        boolean root = parent2 == null;
        return nodeElement instanceof KtElement ? new KotlinCallHierarchyNodeDescriptor(project, parent2, nodeElement, root, navigateToReference) : new CallHierarchyNodeDescriptor(project, parent2, nodeElement, root, navigateToReference);
    }

    protected static PsiElement getTargetElement(HierarchyNodeDescriptor descriptor2) {
        return descriptor2 instanceof CallHierarchyNodeDescriptor ? ((CallHierarchyNodeDescriptor)descriptor2).getEnclosingElement() : ((KotlinCallHierarchyNodeDescriptor)descriptor2).getTargetElement();
    }

    @Nullable
    protected static PsiMethod getRepresentativePsiMethod(PsiElement element2) {
        while ((element2 = PsiUtilsKt.getParentOfTypesAndPredicate(element2, false, ArrayUtil.EMPTY_CLASS_ARRAY, IS_NON_LOCAL_DECLARATION)) != null) {
            PsiMethod method = KotlinCallTreeStructure.getRepresentativePsiMethodForNonLocalDeclaration(element2);
            if (method != null) {
                return method;
            }
            element2 = element2.getParent();
        }
        return null;
    }

    private static PsiMethod getRepresentativePsiMethodForNonLocalDeclaration(PsiElement element2) {
        if (element2 instanceof PsiMethod) {
            return (PsiMethod)element2;
        }
        if (element2 instanceof KtNamedFunction || element2 instanceof KtSecondaryConstructor) {
            return LightClassUtil.INSTANCE.getLightClassMethod((KtFunction)element2);
        }
        if (element2 instanceof KtProperty) {
            LightClassUtil.PropertyAccessorsPsiMethods propertyMethods2 = LightClassUtil.INSTANCE.getLightClassPropertyMethods((KtProperty)element2);
            return propertyMethods2.getGetter() != null ? propertyMethods2.getGetter() : propertyMethods2.getSetter();
        }
        if (element2 instanceof KtClassOrObject) {
            KtLightClass psiClass2 = LightClassUtilsKt.toLightClass((KtClassOrObject)element2);
            if (psiClass2 == null) {
                return null;
            }
            PsiMethod[] constructors2 = psiClass2.getConstructors();
            if (constructors2.length > 0) {
                return constructors2[0];
            }
        }
        return null;
    }

    protected static CallHierarchyNodeDescriptor getJavaNodeDescriptor(HierarchyNodeDescriptor originalDescriptor) {
        if (originalDescriptor instanceof CallHierarchyNodeDescriptor) {
            return (CallHierarchyNodeDescriptor)originalDescriptor;
        }
        assert (originalDescriptor instanceof KotlinCallHierarchyNodeDescriptor);
        return ((KotlinCallHierarchyNodeDescriptor)originalDescriptor).getJavaDelegate();
    }

    protected Object[] collectNodeDescriptors(HierarchyNodeDescriptor descriptor2, Map<PsiReference, PsiElement> referencesToCalleeElements, PsiClass basePsiClass) {
        HashMap declarationToDescriptorMap = new HashMap();
        for (Map.Entry<PsiReference, PsiElement> refToCallee : referencesToCalleeElements.entrySet()) {
            PsiReference ref = refToCallee.getKey();
            PsiElement callee = refToCallee.getValue();
            if (basePsiClass != null && !this.isInScope((PsiElement)basePsiClass, callee, this.scopeType)) continue;
            KotlinCallTreeStructure.addNodeDescriptorForElement(ref, callee, (Map<PsiElement, HierarchyNodeDescriptor>)declarationToDescriptorMap, descriptor2, false);
        }
        return declarationToDescriptorMap.values().toArray(new Object[declarationToDescriptorMap.size()]);
    }

    protected static void addNodeDescriptorForElement(PsiReference reference2, PsiElement element2, Map<PsiElement, HierarchyNodeDescriptor> declarationToDescriptorMap, HierarchyNodeDescriptor descriptor2, boolean wrapAsLightElements) {
        HierarchyNodeDescriptor d = declarationToDescriptorMap.get(element2);
        if (d == null) {
            d = KotlinCallTreeStructure.createNodeDescriptor(element2.getProject(), element2, descriptor2, true, wrapAsLightElements);
            if (d == null) {
                return;
            }
            declarationToDescriptorMap.put(element2, d);
        } else if (d instanceof CallHierarchyNodeDescriptor) {
            ((CallHierarchyNodeDescriptor)d).incrementUsageCount();
        }
        if (d instanceof CallHierarchyNodeDescriptor) {
            ((CallHierarchyNodeDescriptor)d).addReference(reference2);
        } else if (d instanceof KotlinCallHierarchyNodeDescriptor) {
            ((KotlinCallHierarchyNodeDescriptor)d).addReference(reference2);
        }
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }
}

