/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.SeparatorWithText;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.framework.ui.ChooseLibraryPathPanel;
import org.jetbrains.kotlin.idea.framework.ui.ValidityListener;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;

public abstract class CreateLibraryDialogBase
extends DialogWrapper {
    protected JPanel contentPane;
    protected JLabel compilerTextLabel;
    protected JPanel chooseModulesPanelPlace;
    protected SeparatorWithText modulesSeparator;
    protected JPanel chooseLibraryPathPlace;
    protected final ChooseLibraryPathPanel pathPanel;

    public CreateLibraryDialogBase(@Nullable Project project, @NotNull String defaultPath, @NotNull String title, @NotNull String libraryCaption) {
        if (defaultPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultPath", "org/jetbrains/kotlin/idea/framework/ui/CreateLibraryDialogBase", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/kotlin/idea/framework/ui/CreateLibraryDialogBase", "<init>"));
        }
        if (libraryCaption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryCaption", "org/jetbrains/kotlin/idea/framework/ui/CreateLibraryDialogBase", "<init>"));
        }
        super(project);
        this.$$$setupUI$$$();
        this.setTitle(title);
        this.init();
        this.compilerTextLabel.setText(this.compilerTextLabel.getText() + " - " + KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion());
        this.pathPanel = new ChooseLibraryPathPanel(defaultPath);
        this.pathPanel.addValidityListener(new ValidityListener(){

            @Override
            public void validityChanged(boolean isValid2) {
                CreateLibraryDialogBase.this.updateComponents();
            }
        });
        this.pathPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateLibraryDialogBase.this.updateComponents();
            }
        });
        this.chooseLibraryPathPlace.add((Component)this.pathPanel.getContentPane(), "Center");
        this.modulesSeparator.setCaption(libraryCaption);
    }

    protected void updateComponents() {
        this.setOKActionEnabled(!this.pathPanel.hasErrors());
    }

    @Nullable
    public String getCopyIntoPath() {
        return this.chooseLibraryPathPlace.isVisible() ? this.pathPanel.getPath() : null;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        SeparatorWithText separatorWithText;
        JPanel jPanel2;
        JLabel jLabel;
        JPanel jPanel3;
        this.contentPane = jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.compilerTextLabel = jLabel = new JLabel();
        jLabel.setText("Using compiler bundled into plugin");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.chooseModulesPanelPlace = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.modulesSeparator = separatorWithText = new SeparatorWithText();
        jPanel3.add((Component)separatorWithText, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.chooseLibraryPathPlace = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

