/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import java.util.jar.Attributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.LibraryUtils;

public class JavaRuntimeDetectionUtil {
    public static String getJavaRuntimeVersion(@NotNull List<VirtualFile> classesRoots) {
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "org/jetbrains/kotlin/idea/framework/JavaRuntimeDetectionUtil", "getJavaRuntimeVersion"));
        }
        VirtualFile stdJar = JavaRuntimeDetectionUtil.getRuntimeJar(classesRoots);
        if (stdJar != null) {
            return JarUtil.getJarAttribute((File)VfsUtilCore.virtualToIoFile((VirtualFile)stdJar), (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        }
        return null;
    }

    @Nullable
    public static VirtualFile getRuntimeJar(@NotNull List<VirtualFile> classesRoots) {
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "org/jetbrains/kotlin/idea/framework/JavaRuntimeDetectionUtil", "getRuntimeJar"));
        }
        return LibraryUtils.getJarFile(classesRoots, "kotlin-runtime.jar");
    }
}

