/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.editor.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/editor/fixers/KotlinDoWhileFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/editor/KotlinSmartEnterHandler;", "()V", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "psiElement", "Lcom/intellij/psi/PsiElement;", "idea"})
public final class KotlinDoWhileFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public void apply(@NotNull Editor editor, @NotNull KotlinSmartEnterHandler processor2, @NotNull PsiElement psiElement) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)psiElement, (String)"psiElement");
        if (!(psiElement instanceof KtDoWhileExpression)) {
            return;
        }
        Document doc = editor.getDocument();
        int start = FixersUtilKt.getStart(FixersUtilKt.getRange(psiElement));
        KtExpression body2 = ((KtDoWhileExpression)psiElement).getBody();
        PsiElement whileKeyword = ((KtDoWhileExpression)psiElement).getWhileKeyword();
        if (body2 == null) {
            if (whileKeyword == null) {
                doc.replaceString(start, start + "do".length(), (CharSequence)"do {} while()");
            } else {
                doc.insertString(start + "do".length(), (CharSequence)"{}");
            }
            return;
        }
        if (whileKeyword != null && !(body2 instanceof KtBlockExpression)) {
            PsiElement psiElement2 = (PsiElement)body2;
            Document document = doc;
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"doc");
            int n = FixersUtilKt.startLine(psiElement2, document);
            Document document2 = doc;
            Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"doc");
            if (n > FixersUtilKt.startLine(psiElement, document2)) {
                doc.insertString(FixersUtilKt.getStart(FixersUtilKt.getRange(whileKeyword)), (CharSequence)"}");
                doc.insertString(start + "do".length(), (CharSequence)"{");
                return;
            }
        }
        if (((KtDoWhileExpression)psiElement).getCondition() == null) {
            PsiElement lParen = ((KtDoWhileExpression)psiElement).getLeftParenthesis();
            PsiElement rParen = ((KtDoWhileExpression)psiElement).getRightParenthesis();
            if (whileKeyword == null) {
                doc.insertString(FixersUtilKt.getEnd(FixersUtilKt.getRange(psiElement)), (CharSequence)"while()");
            } else if (lParen == null && rParen == null) {
                doc.replaceString(FixersUtilKt.getStart(FixersUtilKt.getRange(whileKeyword)), FixersUtilKt.getEnd(FixersUtilKt.getRange(whileKeyword)), (CharSequence)"while()");
            } else if (lParen != null) {
                processor2.registerUnresolvedError(FixersUtilKt.getEnd(FixersUtilKt.getRange(lParen)));
            }
        }
    }
}

