/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.js;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.idea.decompiler.js.JsMetaFileUtils;
import org.jetbrains.kotlin.idea.decompiler.js.KotlinJavaScriptDeserializerForDecompiler;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DeserializerForDecompilerBase;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.LoggingErrorReporter;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.ResolveEverythingToKotlinAnyLocalClassifierResolver;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.AnnotationAndConstantLoader;
import org.jetbrains.kotlin.serialization.deserialization.AnnotationAndConstantLoaderImpl;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.ClassDescriptorFactory;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationComponents;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.serialization.deserialization.LocalClassifierTypeSettings;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.serialization.deserialization.NotFoundClasses;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPackageMemberScope;
import org.jetbrains.kotlin.serialization.js.JsSerializerProtocol;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptClassDataFinder;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializedResourcePaths;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.DynamicTypeFactory;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/js/KotlinJavaScriptDeserializerForDecompiler;", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DeserializerForDecompilerBase;", "classFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "classDataFinder", "Lorg/jetbrains/kotlin/serialization/js/KotlinJavascriptClassDataFinder;", "deserializationComponents", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "getDeserializationComponents", "()Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolverImpl;", "targetPlatform", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "resolveDeclarationsInFacade", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "facadeFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Companion", "idea-analysis"})
public final class KotlinJavaScriptDeserializerForDecompiler
extends DeserializerForDecompilerBase {
    private final NameResolverImpl nameResolver;
    private final KotlinJavascriptClassDataFinder classDataFinder;
    @NotNull
    private final DeserializationComponents deserializationComponents;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    @NotNull
    protected TargetPlatform getTargetPlatform() {
        return JsPlatform.INSTANCE;
    }

    @Override
    @NotNull
    protected DeserializationComponents getDeserializationComponents() {
        return this.deserializationComponents;
    }

    @Override
    @NotNull
    public List<DeclarationDescriptor> resolveDeclarationsInFacade(@NotNull FqName facadeFqName) {
        Intrinsics.checkParameterIsNotNull((Object)facadeFqName, (String)"facadeFqName");
        FqName packageFqName = facadeFqName.parent();
        boolean bl = Intrinsics.areEqual((Object)packageFqName, (Object)this.getDirectoryPackageFqName());
        if (_Assertions.ENABLED && !bl) {
            String string = "Was called for " + packageFqName + "; only members of " + this.getDirectoryPackageFqName() + " package are expected.";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        String packageFilePath = StringsKt.substringAfterLast$default((String)KotlinJavascriptSerializedResourcePaths.INSTANCE.getPackageFilePath(this.getDirectoryPackageFqName()), (String)"/", null, (int)2, null);
        VirtualFile file2 = this.getPackageDirectory().findChild(packageFilePath);
        if (file2 == null) {
            KotlinJavaScriptDeserializerForDecompiler.Companion.getLOG().error("Could not read data for package " + packageFqName + "; " + packageFilePath + " absent in " + this.getPackageDirectory());
            return CollectionsKt.emptyList();
        }
        byte[] content2 = file2.contentsToByteArray(false);
        ProtoBuf.Package packageProto = ProtoBuf.Package.parseFrom(content2, JsSerializerProtocol.INSTANCE.getExtensionRegistry());
        FqName fqName2 = packageFqName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName");
        PackageFragmentDescriptor packageFragmentDescriptor = this.createDummyPackageFragment(fqName2);
        ProtoBuf.Package package_ = packageProto;
        Intrinsics.checkExpressionValueIsNotNull((Object)package_, (String)"packageProto");
        DeserializedPackageMemberScope membersScope2 = new DeserializedPackageMemberScope(packageFragmentDescriptor, package_, this.nameResolver, null, this.getDeserializationComponents(), (Function0<? extends Collection<Name>>)((Function0)resolveDeclarationsInFacade.membersScope.1.INSTANCE));
        return CollectionsKt.toList((Iterable)ResolutionScope.DefaultImpls.getContributedDescriptors$default(membersScope2, null, null, 3, null));
    }

    public KotlinJavaScriptDeserializerForDecompiler(@NotNull VirtualFile classFile) {
        NameResolverImpl nameResolverImpl;
        Intrinsics.checkParameterIsNotNull((Object)classFile, (String)"classFile");
        VirtualFile virtualFile2 = classFile.getParent();
        if (virtualFile2 == null) {
            Intrinsics.throwNpe();
        }
        super(virtualFile2, JsMetaFileUtils.INSTANCE.getPackageFqName(classFile));
        KotlinJavaScriptDeserializerForDecompiler kotlinJavaScriptDeserializerForDecompiler = this;
        KotlinJavaScriptDeserializerForDecompiler kotlinJavaScriptDeserializerForDecompiler2 = this;
        KotlinJavaScriptDeserializerForDecompiler $receiver = kotlinJavaScriptDeserializerForDecompiler;
        VirtualFile moduleDirectory = JsMetaFileUtils.INSTANCE.getModuleDirectory($receiver.getPackageDirectory());
        String stringsFileName = KotlinJavascriptSerializedResourcePaths.INSTANCE.getStringTableFilePath($receiver.getDirectoryPackageFqName());
        VirtualFile stringsFile = moduleDirectory.findFileByRelativePath(stringsFileName);
        boolean bl = stringsFile != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "strings file not found: " + stringsFileName;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        VirtualFile virtualFile3 = stringsFile;
        if (virtualFile3 == null) {
            Intrinsics.throwNpe();
        }
        kotlinJavaScriptDeserializerForDecompiler2.nameResolver = nameResolverImpl = NameResolverImpl.Companion.read(new ByteArrayInputStream(virtualFile3.contentsToByteArray(false)));
        this.classDataFinder = new KotlinJavascriptClassDataFinder(this.nameResolver, (Function1<? super String, ? extends InputStream>)((Function1)new Function1<String, InputStream>(this){
            final /* synthetic */ KotlinJavaScriptDeserializerForDecompiler this$0;

            @Nullable
            public final InputStream invoke(@NotNull String path) {
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                VirtualFile virtualFile2 = this.this$0.getPackageDirectory().findChild(StringsKt.substringAfterLast$default((String)path, (String)"/", null, (int)2, null));
                return virtualFile2 != null ? virtualFile2.getInputStream() : null;
            }
            {
                this.this$0 = kotlinJavaScriptDeserializerForDecompiler;
                super(1);
            }
        }));
        NotFoundClasses notFoundClasses = new NotFoundClasses(this.getStorageManager(), this.getModuleDescriptor());
        AnnotationAndConstantLoaderImpl annotationAndConstantLoader = new AnnotationAndConstantLoaderImpl(this.getModuleDescriptor(), notFoundClasses, JsSerializerProtocol.INSTANCE);
        StorageManager storageManager = this.getStorageManager();
        ModuleDescriptor moduleDescriptor = this.getModuleDescriptor();
        DeserializationConfiguration deserializationConfiguration = DeserializationConfiguration.Default.INSTANCE;
        ClassDataFinder classDataFinder2 = this.classDataFinder;
        AnnotationAndConstantLoader annotationAndConstantLoader2 = annotationAndConstantLoader;
        PackageFragmentProvider packageFragmentProvider2 = this.getPackageFragmentProvider();
        LocalClassifierTypeSettings localClassifierTypeSettings = new ResolveEverythingToKotlinAnyLocalClassifierResolver(this.getTargetPlatform().getBuiltIns());
        Logger logger = KotlinJavaScriptDeserializerForDecompiler.Companion.getLOG();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
        this.deserializationComponents = new DeserializationComponents(storageManager, moduleDescriptor, deserializationConfiguration, classDataFinder2, annotationAndConstantLoader2, packageFragmentProvider2, localClassifierTypeSettings, new LoggingErrorReporter(logger), LookupTracker.Companion.getDO_NOTHING(), DynamicTypeFactory.INSTANCE, ClassDescriptorFactory.EMPTY.INSTANCE, notFoundClasses, null, null, 12288, null);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(KotlinJavaScriptDeserializerForDecompiler.class);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/js/KotlinJavaScriptDeserializerForDecompiler$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "idea-analysis"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

