/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.js;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.decompiler.js.KotlinJavaScriptMetaFileType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializedResourcePathsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/js/JsMetaFileUtils;", "", "()V", "getClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "relPath", "", "getClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "getModuleDirectory", "getModuleName", "getPackageFqName", "getRelativeToRootPath", "getRoot", "isKotlinJavaScriptInternalCompiledFile", "", "isKotlinJsMetaFile", "isPackageHeader", "idea-analysis"})
public final class JsMetaFileUtils {
    public static final JsMetaFileUtils INSTANCE;

    public final boolean isKotlinJsMetaFile(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return Intrinsics.areEqual((Object)file2.getFileType(), (Object)KotlinJavaScriptMetaFileType.INSTANCE);
    }

    public final boolean isKotlinJavaScriptInternalCompiledFile(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return this.isKotlinJsMetaFile(file2) && StringsKt.contains$default((CharSequence)file2.getNameWithoutExtension(), (char)'.', (boolean)false, (int)2, null);
    }

    @NotNull
    public final FqName getPackageFqName(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return this.getPackageFqName(this.getRelativeToRootPath(file2));
    }

    @NotNull
    public final FqName getClassFqName(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return this.getClassFqName(this.getRelativeToRootPath(file2));
    }

    @NotNull
    public final ClassId getClassId(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return this.getClassId(this.getRelativeToRootPath(file2));
    }

    public final boolean isPackageHeader(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return this.isPackageHeader(this.getRelativeToRootPath(file2));
    }

    @NotNull
    public final VirtualFile getModuleDirectory(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        VirtualFile virtualFile2 = this.getRoot(file2).findChild(this.getModuleName(this.getRelativeToRootPath(file2)));
        if (virtualFile2 == null) {
            Intrinsics.throwNpe();
        }
        return virtualFile2;
    }

    private final String getRelativeToRootPath(VirtualFile file2) {
        String string = VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)this.getRoot(file2));
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    private final FqName getClassFqName(String relPath) {
        String pathToFile = StringsKt.substringAfter$default((String)relPath, (char)'/', null, (int)2, null);
        return new FqName(StringsKt.replace$default((String)StringsKt.substringBeforeLast$default((String)pathToFile, (char)'.', null, (int)2, null), (char)'/', (char)'.', (boolean)false, (int)4, null));
    }

    private final ClassId getClassId(String relPath) {
        FqName classFqName = this.getClassFqName(relPath);
        FqName packageFqName = this.getPackageFqName(relPath);
        String name2 = StringsKt.substringBeforeLast$default((String)classFqName.shortName().asString(), (char)'.', null, (int)2, null);
        return new ClassId(packageFqName, new FqName(name2), false);
    }

    private final FqName getPackageFqName(String relPath) {
        String pathToFile = StringsKt.substringAfter$default((String)relPath, (char)'/', null, (int)2, null);
        if (KotlinJavascriptSerializedResourcePathsKt.isDefaultPackageMetafile(pathToFile)) {
            FqName fqName2 = FqName.ROOT;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"FqName.ROOT");
            return fqName2;
        }
        String name2 = StringsKt.substringBeforeLast$default((String)pathToFile, (char)'/', null, (int)2, null);
        return new FqName(StringsKt.replace$default((String)name2, (char)'/', (char)'.', (boolean)false, (int)4, null));
    }

    private final String getModuleName(String relPath) {
        return StringsKt.substringBefore$default((String)relPath, (char)'/', null, (int)2, null);
    }

    private final boolean isPackageHeader(String relPath) {
        FqName classFqName = this.getClassFqName(relPath);
        return KotlinJavascriptSerializedResourcePathsKt.isPackageClassFqName(classFqName);
    }

    private final VirtualFile getRoot(VirtualFile file2) {
        VirtualFile virtualFile2;
        if (file2.getParent() == null) {
            virtualFile2 = file2;
        } else {
            VirtualFile virtualFile3 = file2.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"file.parent");
            virtualFile2 = this.getRoot(virtualFile3);
        }
        return virtualFile2;
    }

    private JsMetaFileUtils() {
        INSTANCE = this;
    }

    static {
        new JsMetaFileUtils();
    }
}

