/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoHandler;
import com.intellij.debugger.actions.MethodSmartStepTarget;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Range;
import com.intellij.util.containers.OrderedSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethods;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinBasicStepMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinLambdaMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinLambdaSmartStepTarget;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinMethodSmartStepTarget;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinSmartStepIntoHandler;", "Lcom/intellij/debugger/actions/JvmSmartStepIntoHandler;", "()V", "methods", "Lorg/jetbrains/kotlin/codegen/intrinsics/IntrinsicMethods;", "createMethodFilter", "Lcom/intellij/debugger/engine/MethodFilter;", "stepTarget", "Lcom/intellij/debugger/actions/SmartStepTarget;", "findSmartStepTargets", "", "position", "Lcom/intellij/debugger/SourcePosition;", "isAvailable", "", "isIntrinsic", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "idea"})
public final class KotlinSmartStepIntoHandler
extends JvmSmartStepIntoHandler {
    private final IntrinsicMethods methods = new IntrinsicMethods();

    public boolean isAvailable(@Nullable SourcePosition position2) {
        SourcePosition sourcePosition2 = position2;
        return (sourcePosition2 != null ? sourcePosition2.getFile() : null) instanceof KtFile;
    }

    @NotNull
    public List<SmartStepTarget> findSmartStepTargets(@NotNull SourcePosition position2) {
        Intrinsics.checkParameterIsNotNull((Object)position2, (String)"position");
        PsiFile file2 = position2.getFile();
        PsiElement psiElement = position2.getElementAt();
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement elementAtOffset = psiElement;
        PsiElement element2 = CodeInsightUtils.getTopmostElementAtOffset(elementAtOffset, elementAtOffset.getTextRange().getStartOffset());
        if (!(element2 instanceof KtElement)) {
            return CollectionsKt.emptyList();
        }
        TextRange textRange = ((KtElement)element2).getTextRange();
        if (textRange == null) {
            return CollectionsKt.emptyList();
        }
        TextRange elementTextRange = textRange;
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document == null) {
            return CollectionsKt.emptyList();
        }
        Document doc = document;
        Range lines = new Range((Comparable)Integer.valueOf(doc.getLineNumber(elementTextRange.getStartOffset())), (Comparable)Integer.valueOf(doc.getLineNumber(elementTextRange.getEndOffset())));
        BindingContext bindingContext2 = ResolutionUtils.analyzeFully((KtElement)element2);
        OrderedSet result2 = new OrderedSet();
        ((KtElement)element2).accept(new KtTreeVisitorVoid(this, result2, lines, bindingContext2, file2){
            final /* synthetic */ KotlinSmartStepIntoHandler this$0;
            final /* synthetic */ OrderedSet $result;
            final /* synthetic */ Range $lines;
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ PsiFile $file;

            public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
                Intrinsics.checkParameterIsNotNull((Object)lambdaExpression, (String)"lambdaExpression");
                KtFunction ktFunction = lambdaExpression.getFunctionLiteral();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFunction, (String)"lambdaExpression.functionLiteral");
                this.recordFunctionLiteral(ktFunction);
            }

            public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
                if (!this.recordFunctionLiteral(function2)) {
                    super.visitNamedFunction(function2);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final boolean recordFunctionLiteral(KtFunction function2) {
                BindingContext context = ResolutionUtils.analyze$default(function2, null, 1, null);
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(CallUtilKt.getParentCall$default(function2, context, false, 2, null), context);
                if (resolvedCall2 != null) {
                    Map<ValueParameterDescriptor, ResolvedValueArgument> arguments2;
                    Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = arguments2 = resolvedCall2.getValueArguments();
                    Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = map2.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        boolean bl;
                        ValueParameterDescriptor param;
                        block3: {
                            void $receiver$iv;
                            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry;
                            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry2 = entry = iterator2.next();
                            param = entry2.getKey();
                            Object object = entry;
                            ResolvedValueArgument argument2 = object.getValue();
                            object = argument2.getArguments();
                            for (T element$iv : $receiver$iv) {
                                ValueArgument it;
                                ValueArgument valueArgument = it = (ValueArgument)element$iv;
                                Intrinsics.checkExpressionValueIsNotNull((Object)valueArgument, (String)"it");
                                if (!Intrinsics.areEqual((Object)this.getArgumentExpression(valueArgument), (Object)function2)) continue;
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                        if (!bl) continue;
                        DeclarationDescriptor declarationDescriptor = resolvedCall2.getResultingDescriptor();
                        Name name2 = param.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"param.name");
                        String label2 = KotlinLambdaSmartStepTarget.Companion.calcLabel(declarationDescriptor, name2);
                        this.$result.add((Object)((Object)new KotlinLambdaSmartStepTarget(label2, function2, (Range<Integer>)this.$lines, InlineUtil.isInline(resolvedCall2.getResultingDescriptor()))));
                        return true;
                    }
                }
                return false;
            }

            private final KtExpression getArgumentExpression(ValueArgument it) {
                KtExpression ktExpression;
                KtExpression ktExpression2 = it.getArgumentExpression();
                if (!(ktExpression2 instanceof KtLambdaExpression)) {
                    ktExpression2 = null;
                }
                return (ktExpression = (KtLambdaExpression)ktExpression2) != null && (ktExpression = ktExpression.getFunctionLiteral()) != null ? (KtExpression)ktExpression : it.getArgumentExpression();
            }

            public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            }

            public void visitIfExpression(@NotNull KtIfExpression expression2) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    KtExpression ktExpression = expression2.getCondition();
                    if (ktExpression == null) break block0;
                    ktExpression.accept(this);
                }
            }

            public void visitWhileExpression(@NotNull KtWhileExpression expression2) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    KtExpression ktExpression = expression2.getCondition();
                    if (ktExpression == null) break block0;
                    ktExpression.accept(this);
                }
            }

            public void visitDoWhileExpression(@NotNull KtDoWhileExpression expression2) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    KtExpression ktExpression = expression2.getCondition();
                    if (ktExpression == null) break block0;
                    ktExpression.accept(this);
                }
            }

            public void visitForExpression(@NotNull KtForExpression expression2) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    KtExpression ktExpression = expression2.getLoopRange();
                    if (ktExpression == null) break block0;
                    ktExpression.accept(this);
                }
            }

            public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    KtExpression ktExpression = expression2.getSubjectExpression();
                    if (ktExpression == null) break block0;
                    ktExpression.accept(this);
                }
            }

            public void visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                this.recordFunction(expression2);
                super.visitArrayAccessExpression(expression2);
            }

            public void visitUnaryExpression(@NotNull KtUnaryExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                KtExpression ktExpression = expression2.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.operationReference");
                this.recordFunction(ktExpression);
                super.visitUnaryExpression(expression2);
            }

            public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                KtExpression ktExpression = expression2.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.operationReference");
                this.recordFunction(ktExpression);
                super.visitBinaryExpression(expression2);
            }

            public void visitCallExpression(@NotNull KtCallExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                KtExpression calleeExpression = expression2.getCalleeExpression();
                if (calleeExpression != null) {
                    this.recordFunction(calleeExpression);
                }
                super.visitCallExpression(expression2);
            }

            public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
                PropertyGetterDescriptor getterDescriptor;
                CallableDescriptor propertyDescriptor;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.$bindingContext);
                if (resolvedCall2 != null && (propertyDescriptor = resolvedCall2.getResultingDescriptor()) instanceof PropertyDescriptor && (getterDescriptor = ((PropertyDescriptor)propertyDescriptor).getGetter()) != null && !getterDescriptor.isDefault()) {
                    ResolvedCall delegatedResolvedCall = (ResolvedCall)this.$bindingContext.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, getterDescriptor);
                    if (delegatedResolvedCall == null) {
                        Project project = this.$file.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
                        PsiElement getter = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, getterDescriptor);
                        if (getter instanceof KtPropertyAccessor && (((KtPropertyAccessor)getter).getBodyExpression() != null || ((KtPropertyAccessor)getter).getEqualsToken() != null)) {
                            String label2 = KotlinMethodSmartStepTarget.Companion.calcLabel(getterDescriptor);
                            this.$result.add((Object)((Object)new KotlinMethodSmartStepTarget((KtElement)getter, label2, (PsiElement)expression2, (Range<Integer>)this.$lines)));
                        }
                    } else {
                        FunctionDescriptor delegatedPropertyGetterDescriptor = (FunctionDescriptor)delegatedResolvedCall.getResultingDescriptor();
                        if (delegatedPropertyGetterDescriptor instanceof CallableMemberDescriptor) {
                            Project project = this.$file.getProject();
                            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
                            DeclarationDescriptor declarationDescriptor = delegatedPropertyGetterDescriptor;
                            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"delegatedPropertyGetterDescriptor");
                            PsiElement function2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, declarationDescriptor);
                            if (function2 instanceof KtNamedFunction || function2 instanceof KtSecondaryConstructor) {
                                StringBuilder stringBuilder = new StringBuilder().append(((PropertyDescriptor)propertyDescriptor).getName() + ".");
                                DeclarationDescriptor declarationDescriptor2 = delegatedPropertyGetterDescriptor;
                                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"delegatedPropertyGetterDescriptor");
                                String label3 = stringBuilder.append(KotlinMethodSmartStepTarget.Companion.calcLabel(declarationDescriptor2)).toString();
                                PsiElement psiElement = function2;
                                if (psiElement == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
                                }
                                this.$result.add((Object)((Object)new KotlinMethodSmartStepTarget((KtFunction)psiElement, label3, (PsiElement)expression2, (Range<Integer>)this.$lines)));
                            }
                        }
                    }
                }
                super.visitSimpleNameExpression(expression2);
            }

            private final void recordFunction(KtExpression expression2) {
                block3: {
                    PsiElement resolvedElement;
                    CallableDescriptor descriptor2;
                    block5: {
                        block4: {
                            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.$bindingContext);
                            if (resolvedCall2 == null) {
                                return;
                            }
                            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
                            descriptor2 = resolvedCall3.getResultingDescriptor();
                            if (!(descriptor2 instanceof FunctionDescriptor) || KotlinSmartStepIntoHandler.access$isIntrinsic(this.this$0, (CallableMemberDescriptor)descriptor2)) break block3;
                            Project project = this.$file.getProject();
                            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
                            resolvedElement = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, descriptor2);
                            if (!(resolvedElement instanceof KtNamedFunction) && !(resolvedElement instanceof KtConstructor)) break block4;
                            String label2 = KotlinMethodSmartStepTarget.Companion.calcLabel(descriptor2);
                            PsiElement psiElement = resolvedElement;
                            if (psiElement == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
                            }
                            this.$result.add((Object)((Object)new KotlinMethodSmartStepTarget((KtFunction)psiElement, label2, (PsiElement)expression2, (Range<Integer>)this.$lines)));
                            break block3;
                        }
                        if (!(resolvedElement instanceof PsiMethod)) break block5;
                        this.$result.add((Object)new MethodSmartStepTarget((PsiMethod)resolvedElement, (String)null, (PsiElement)expression2, false, this.$lines));
                        break block3;
                    }
                    if (!(resolvedElement instanceof KtClass)) break block3;
                    KtAnonymousInitializer ktAnonymousInitializer = (KtAnonymousInitializer)CollectionsKt.firstOrNull(((KtClass)resolvedElement).getAnonymousInitializers());
                    if (ktAnonymousInitializer != null) {
                        KtAnonymousInitializer ktAnonymousInitializer2 = ktAnonymousInitializer;
                        KtAnonymousInitializer it = ktAnonymousInitializer2;
                        String label3 = KotlinMethodSmartStepTarget.Companion.calcLabel(descriptor2);
                        this.$result.add((Object)((Object)new KotlinMethodSmartStepTarget(it, label3, (PsiElement)expression2, (Range<Integer>)this.$lines)));
                    }
                }
            }
            {
                this.this$0 = $outer;
                this.$result = $captured_local_variable$1;
                this.$lines = $captured_local_variable$2;
                this.$bindingContext = $captured_local_variable$3;
                this.$file = $captured_local_variable$4;
            }
        }, null);
        return (List)result2;
    }

    @Nullable
    protected MethodFilter createMethodFilter(@Nullable SmartStepTarget stepTarget) {
        MethodFilter methodFilter2;
        SmartStepTarget smartStepTarget = stepTarget;
        if (smartStepTarget instanceof KotlinMethodSmartStepTarget) {
            KtElement ktElement = ((KotlinMethodSmartStepTarget)stepTarget).getResolvedElement();
            Range range = ((KotlinMethodSmartStepTarget)stepTarget).getCallingExpressionLines();
            if (range == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)range, (String)"stepTarget.callingExpressionLines!!");
            methodFilter2 = (MethodFilter)new KotlinBasicStepMethodFilter(ktElement, (Range<Integer>)range);
        } else if (smartStepTarget instanceof KotlinLambdaSmartStepTarget) {
            KtFunction ktFunction = ((KotlinLambdaSmartStepTarget)stepTarget).getLambda();
            Range range = ((KotlinLambdaSmartStepTarget)stepTarget).getCallingExpressionLines();
            if (range == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)range, (String)"stepTarget.callingExpressionLines!!");
            methodFilter2 = (MethodFilter)new KotlinLambdaMethodFilter(ktFunction, (Range<Integer>)range, ((KotlinLambdaSmartStepTarget)stepTarget).isInline());
        } else {
            methodFilter2 = super.createMethodFilter(stepTarget);
        }
        return methodFilter2;
    }

    private final boolean isIntrinsic(CallableMemberDescriptor descriptor2) {
        return this.methods.getIntrinsic(descriptor2) != null;
    }

    public static final /* synthetic */ boolean access$isIntrinsic(KotlinSmartStepIntoHandler $this, @NotNull CallableMemberDescriptor descriptor2) {
        return $this.isIntrinsic(descriptor2);
    }
}

