/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.ObjectValue;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValuesKt;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilderKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0001+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J$\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J,\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J$\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J*\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fJ\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0002J,\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\"\u0010 \u001a\u0004\u0018\u00010\u000b2\u0006\u0010!\u001a\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000fJ\u0012\u0010#\u001a\u00020\u000f2\b\u0010$\u001a\u0004\u0018\u00010\u0013H\u0002J\"\u0010%\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010&\u001a\u00020\u000fH\u0002J\f\u0010'\u001a\u00020\u000f*\u00020\u000bH\u0002J\u0016\u0010(\u001a\u00020\u000f*\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\rH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameVisitor;", "", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "(Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;)V", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "fail", "Lorg/jetbrains/eval4j/Value;", "message", "", "shouldFail", "", "findCapturedLocalVariable", "name", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "checkType", "findLocalVariable", "findLocalVariableForInlineArgument", "number", "", "findLocalVariableForLocalFun", "findThis", "findValue", "failIfNotFound", "getCapturedFieldName", "getField", "owner", "getValueIfSharedVar", "value", "expectedType", "isFunctionType", "type", "isValueOfCorrectType", "shouldCheckType", "isSharedVar", "isSubclass", "Lcom/sun/jdi/Type;", "superClassName", "Companion", "idea"})
public final class FrameVisitor {
    private final GlobalSearchScope scope;
    private final StackFrameProxyImpl frame;
    private static final Type OBJECT_TYPE;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Value findValue(@NotNull String name2, @Nullable Type asmType, boolean checkType2, boolean failIfNotFound) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        if (this.frame == null) {
            return null;
        }
        try {
            String string = name2;
            if (Intrinsics.areEqual((Object)string, (Object)KotlinEvaluationBuilderKt.getTHIS_NAME())) {
                Value thisValue = this.findThis(asmType);
                if (thisValue != null) {
                    return thisValue;
                }
            } else {
                Value variableForLocalFun;
                List list2 = this.frame.visibleVariables();
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"frame.visibleVariables()");
                if (DebuggerUtilKt.isInsideInlineFunctionBody(list2)) {
                    int number;
                    List list3 = this.frame.visibleVariables();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"frame.visibleVariables()");
                    int n = number = DebuggerUtilKt.numberOfInlinedFunctions(list3);
                    int n2 = 1;
                    if (n >= n2) {
                        while (true) {
                            void inlineFunctionIndex;
                            Value inlineFunVar;
                            if ((inlineFunVar = this.findLocalVariableForInlineArgument(name2, (int)inlineFunctionIndex, asmType, true)) != null) {
                                return inlineFunVar;
                            }
                            if (inlineFunctionIndex == n2) break;
                            --inlineFunctionIndex;
                        }
                    }
                }
                if (this.isFunctionType(asmType) && (variableForLocalFun = this.findLocalVariableForLocalFun(name2, asmType, checkType2)) != null) {
                    return variableForLocalFun;
                }
                Value localVariable = this.findLocalVariable(name2, asmType, checkType2);
                if (localVariable != null) {
                    return localVariable;
                }
                String capturedValName = this.getCapturedFieldName(name2);
                Value capturedVal = this.findCapturedLocalVariable(capturedValName, asmType, checkType2);
                if (capturedVal != null) {
                    return capturedVal;
                }
            }
            return this.fail("Cannot find local variable: name = " + name2 + (checkType2 ? ", type = " + String.valueOf(asmType) : ""), failIfNotFound);
        }
        catch (InvalidStackFrameException e) {
            Throwable throwable = (Throwable)EvaluateExceptionUtil.createEvaluateException((String)("Local variable " + name2 + " is unavailable in current frame"));
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026ilable in current frame\")");
            throw throwable;
        }
    }

    private final Value fail(String message2, boolean shouldFail) {
        if (shouldFail) {
            Throwable throwable = (Throwable)EvaluateExceptionUtil.createEvaluateException((String)message2);
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026valuateException(message)");
            throw throwable;
        }
        return null;
    }

    private final Value findThis(Type asmType) {
        ObjectValue eval4jValue;
        ObjectReference thisObject;
        StackFrameProxyImpl stackFrameProxyImpl = this.frame;
        if (stackFrameProxyImpl == null) {
            Intrinsics.throwNpe();
        }
        List list2 = stackFrameProxyImpl.visibleVariables();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"frame!!.visibleVariables()");
        if (DebuggerUtilKt.isInsideInlineFunctionBody(list2)) {
            List list3 = this.frame.visibleVariables();
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"frame.visibleVariables()");
            int number = DebuggerUtilKt.numberOfInlinedFunctions(list3);
            Value inlineFunVar = this.findLocalVariableForInlineArgument("this_", number, asmType, true);
            if (inlineFunVar != null) {
                return inlineFunVar;
            }
        }
        if ((thisObject = this.frame.thisObject()) != null && this.isValueOfCorrectType(eval4jValue = JdiValuesKt.asValue(thisObject), asmType, true)) {
            return eval4jValue;
        }
        Value receiver = this.findValue(KotlinEvaluationBuilderKt.getRECEIVER_NAME(), asmType, true, false);
        if (receiver != null) {
            return receiver;
        }
        Value this0 = this.findValue("this$0", asmType, true, false);
        if (this0 != null) {
            return this0;
        }
        Value $this = this.findValue("$this", asmType, false, false);
        if ($this != null) {
            return $this;
        }
        return null;
    }

    private final Value findLocalVariableForLocalFun(String name2, Type asmType, boolean checkType2) {
        return this.findLocalVariable(name2 + "$", asmType, checkType2);
    }

    private final Value findLocalVariableForInlineArgument(String name2, int number, Type asmType, boolean checkType2) {
        return this.findLocalVariable(name2 + StringsKt.repeat((CharSequence)"$iv", (int)number), asmType, checkType2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFunctionType(Type type2) {
        Type type3 = type2;
        if (!Intrinsics.areEqual((Object)(type3 != null ? Integer.valueOf(type3.getSort()) : null), (Object)10)) return false;
        Type type4 = type2;
        if (type4 == null) {
            Intrinsics.throwNpe();
        }
        if (!StringsKt.startsWith$default((String)type4.getInternalName(), (String)"kotlin/jvm/functions/Function", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final Value findLocalVariable(String name2, Type asmType, boolean checkType2) {
        StackFrameProxyImpl stackFrameProxyImpl = this.frame;
        if (stackFrameProxyImpl == null) {
            Intrinsics.throwNpe();
        }
        LocalVariableProxyImpl localVariableProxyImpl = stackFrameProxyImpl.visibleVariableByName(name2);
        if (localVariableProxyImpl == null) {
            return null;
        }
        LocalVariableProxyImpl localVariable = localVariableProxyImpl;
        Value eval4jValue = JdiValuesKt.asValue(this.frame.getValue(localVariable));
        Value sharedVarValue = this.getValueIfSharedVar(eval4jValue, asmType, checkType2);
        if (sharedVarValue != null) {
            return sharedVarValue;
        }
        if (this.isValueOfCorrectType(eval4jValue, asmType, checkType2)) {
            return eval4jValue;
        }
        return null;
    }

    private final Value findCapturedLocalVariable(String name2, Type asmType, boolean checkType2) {
        Object object = this.frame;
        if (object == null || (object = object.thisObject()) == null) {
            return null;
        }
        Object thisObject = object;
        Value thisObj = JdiValuesKt.asValue((ObjectReference)thisObject);
        Value capturedVal = null;
        while (capturedVal == null && thisObj != null) {
            capturedVal = this.getField(thisObj, name2, asmType, checkType2);
            if (capturedVal != null) continue;
            thisObj = this.getField(thisObj, "this$0", null, false);
        }
        if (capturedVal != null) {
            Value sharedVarValue = this.getValueIfSharedVar(capturedVal, asmType, checkType2);
            if (sharedVarValue != null) {
                return sharedVarValue;
            }
            return capturedVal;
        }
        return null;
    }

    private final boolean isValueOfCorrectType(Value value2, Type asmType, boolean shouldCheckType) {
        if (!shouldCheckType || asmType == null || Intrinsics.areEqual((Object)value2.getAsmType(), (Object)asmType)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)asmType, (Object)Companion.getOBJECT_TYPE())) {
            return true;
        }
        Object object = ValuesKt.obj$default(value2, null, 1, null);
        if (!(object instanceof ObjectReference)) {
            object = null;
        }
        ObjectReference objectReference = (ObjectReference)object;
        com.sun.jdi.Type type2 = objectReference != null ? objectReference.referenceType() : null;
        String string = asmType.getClassName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"asmType.className");
        if (this.isSubclass(type2, string)) {
            return true;
        }
        Type type3 = value2.getAsmType();
        GlobalSearchScope globalSearchScope = this.scope;
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"scope");
        ClassDescriptor thisDesc = KotlinEvaluationBuilderKt.getClassDescriptor(type3, globalSearchScope);
        GlobalSearchScope globalSearchScope2 = this.scope;
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope2, (String)"scope");
        ClassDescriptor expDesc = KotlinEvaluationBuilderKt.getClassDescriptor(asmType, globalSearchScope2);
        return thisDesc != null && expDesc != null && (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(thisDesc, expDesc){
            final /* synthetic */ ClassDescriptor $thisDesc;
            final /* synthetic */ ClassDescriptor $expDesc;

            public final boolean invoke() {
                return DescriptorUtils.isSubclass(this.$thisDesc, this.$expDesc);
            }
            {
                this.$thisDesc = classDescriptor;
                this.$expDesc = classDescriptor2;
                super(0);
            }
        }) != false;
    }

    private final Value getField(Value owner, String name2, Type asmType, boolean checkType2) {
        try {
            StackFrameProxyImpl stackFrameProxyImpl = this.frame;
            if (stackFrameProxyImpl == null) {
                Intrinsics.throwNpe();
            }
            VirtualMachine virtualMachine = stackFrameProxyImpl.getVirtualMachine().getVirtualMachine();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine, (String)"frame!!.virtualMachine.virtualMachine");
            com.sun.jdi.Value obj = JdiValuesKt.asJdiValue(owner, virtualMachine, owner.getAsmType());
            if (!(obj instanceof ObjectReference)) {
                return null;
            }
            ReferenceType _class = ((ObjectReference)obj).referenceType();
            Field field2 = _class.fieldByName(name2);
            if (field2 == null) {
                return null;
            }
            Field field3 = field2;
            Value fieldValue = JdiValuesKt.asValue(((ObjectReference)obj).getValue(field3));
            if (this.isValueOfCorrectType(fieldValue, asmType, checkType2)) {
                return fieldValue;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private final boolean isSharedVar(@NotNull Value $receiver) {
        return $receiver.getAsmType().getSort() == 10 && StringsKt.startsWith$default((String)$receiver.getAsmType().getInternalName(), (String)"kotlin/jvm/internal/Ref$", (boolean)false, (int)2, null);
    }

    @Nullable
    public final Value getValueIfSharedVar(@NotNull Value value2, @Nullable Type expectedType, boolean checkType2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        if (!this.isSharedVar(value2)) {
            return null;
        }
        Value sharedVarValue = this.getField(value2, "element", expectedType, checkType2);
        if (sharedVarValue != null && this.isValueOfCorrectType(sharedVarValue, expectedType, checkType2)) {
            return sharedVarValue;
        }
        return null;
    }

    private final String getCapturedFieldName(String name2) {
        String string = name2;
        return Intrinsics.areEqual((Object)string, (Object)KotlinEvaluationBuilderKt.getRECEIVER_NAME()) ? "receiver$0" : (Intrinsics.areEqual((Object)string, (Object)KotlinEvaluationBuilderKt.getTHIS_NAME()) ? "this$0" : (Intrinsics.areEqual((Object)string, (Object)"receiver$0") ? name2 : (Intrinsics.areEqual((Object)string, (Object)"this$0") ? name2 : "$" + name2)));
    }

    private final boolean isSubclass(@Nullable com.sun.jdi.Type $receiver, String superClassName) {
        boolean bl;
        block4: {
            if (!($receiver instanceof ClassType)) {
                return false;
            }
            Iterable $receiver$iv = ((ClassType)$receiver).allInterfaces();
            for (Object element$iv : $receiver$iv) {
                InterfaceType it = (InterfaceType)element$iv;
                if (!Intrinsics.areEqual((Object)it.name(), (Object)superClassName)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        for (ClassType superClass = ((ClassType)$receiver).superclass(); superClass != null; superClass = superClass.superclass()) {
            if (!Intrinsics.areEqual((Object)superClass.name(), (Object)superClassName)) continue;
            return true;
        }
        return false;
    }

    public FrameVisitor(@NotNull EvaluationContextImpl context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.scope = context.getDebugProcess().getSearchScope();
        this.frame = context.getFrameProxy();
    }

    static {
        Companion = new Companion(null);
        OBJECT_TYPE = Type.getType(Object.class);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameVisitor$Companion;", "", "()V", "OBJECT_TYPE", "Lorg/jetbrains/org/objectweb/asm/Type;", "kotlin.jvm.PlatformType", "getOBJECT_TYPE", "()Lorg/jetbrains/org/objectweb/asm/Type;", "idea"})
    public static final class Companion {
        public final Type getOBJECT_TYPE() {
            return OBJECT_TYPE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

