/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.quickfix;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

public class QuickFixUtil {
    private QuickFixUtil() {
    }

    public static boolean removePossiblyWhiteSpace(ASTDelegatePsiElement element2, PsiElement possiblyWhiteSpace) {
        if (possiblyWhiteSpace instanceof PsiWhiteSpace) {
            element2.deleteChildInternal(possiblyWhiteSpace.getNode());
            return true;
        }
        return false;
    }

    @Nullable
    public static <T extends PsiElement> T getParentElementOfType(Diagnostic diagnostic, Class<T> aClass2) {
        return (T)PsiTreeUtil.getParentOfType((PsiElement)diagnostic.getPsiElement(), aClass2, (boolean)false);
    }

    @Nullable
    public static KotlinType getDeclarationReturnType(KtNamedDeclaration declaration) {
        PsiFile file2 = declaration.getContainingFile();
        if (!(file2 instanceof KtFile)) {
            return null;
        }
        DeclarationDescriptor descriptor2 = ResolutionUtils.resolveToDescriptor(declaration);
        if (!(descriptor2 instanceof CallableDescriptor)) {
            return null;
        }
        KotlinType type2 = ((CallableDescriptor)descriptor2).getReturnType();
        if (type2 instanceof DeferredType) {
            type2 = ((DeferredType)type2).getDelegate();
        }
        return type2;
    }

    @Nullable
    public static KotlinType findLowerBoundOfOverriddenCallablesReturnTypes(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/core/quickfix/QuickFixUtil", "findLowerBoundOfOverriddenCallablesReturnTypes"));
        }
        KotlinType matchingReturnType = null;
        for (CallableDescriptor callableDescriptor : descriptor2.getOverriddenDescriptors()) {
            KotlinType overriddenReturnType = callableDescriptor.getReturnType();
            if (overriddenReturnType == null) {
                return null;
            }
            if (matchingReturnType == null || KotlinTypeChecker.DEFAULT.isSubtypeOf(overriddenReturnType, matchingReturnType)) {
                matchingReturnType = overriddenReturnType;
                continue;
            }
            if (KotlinTypeChecker.DEFAULT.isSubtypeOf(matchingReturnType, overriddenReturnType)) continue;
            return null;
        }
        return matchingReturnType;
    }

    @Nullable
    public static PsiElement safeGetDeclaration(@Nullable CallableDescriptor descriptor2) {
        if (descriptor2 == null || descriptor2.getOverriddenDescriptors().size() > 1) {
            return null;
        }
        return DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
    }

    @Nullable
    public static KtParameter getParameterDeclarationForValueArgument(@NotNull ResolvedCall<?> resolvedCall2, @Nullable ValueArgument valueArgument) {
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/idea/core/quickfix/QuickFixUtil", "getParameterDeclarationForValueArgument"));
        }
        PsiElement declaration = QuickFixUtil.safeGetDeclaration(CallUtilKt.getParameterForArgument(resolvedCall2, valueArgument));
        return declaration instanceof KtParameter ? (KtParameter)declaration : null;
    }

    private static boolean equalOrLastInThenOrElse(KtExpression thenOrElse, KtExpression expression2) {
        if (thenOrElse == expression2) {
            return true;
        }
        return thenOrElse instanceof KtBlockExpression && expression2.getParent() == thenOrElse && PsiTreeUtil.getNextSiblingOfType((PsiElement)expression2, KtExpression.class) == null;
    }

    @Nullable
    public static KtIfExpression getParentIfForBranch(@Nullable KtExpression expression2) {
        KtIfExpression ifExpression2 = (KtIfExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, KtIfExpression.class, (boolean)true);
        if (ifExpression2 == null) {
            return null;
        }
        if (QuickFixUtil.equalOrLastInThenOrElse(ifExpression2.getThen(), expression2) || QuickFixUtil.equalOrLastInThenOrElse(ifExpression2.getElse(), expression2)) {
            return ifExpression2;
        }
        return null;
    }

    public static boolean canEvaluateTo(KtExpression parent2, KtExpression child) {
        if (parent2 == null || child == null) {
            return false;
        }
        while (parent2 != child) {
            if (child.getParent() instanceof KtParenthesizedExpression) {
                child = (KtExpression)child.getParent();
                continue;
            }
            if ((child = QuickFixUtil.getParentIfForBranch(child)) != null) continue;
            return false;
        }
        return true;
    }

    public static boolean canFunctionOrGetterReturnExpression(@NotNull KtDeclaration functionOrGetter, @NotNull KtExpression expression2) {
        if (functionOrGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionOrGetter", "org/jetbrains/kotlin/idea/core/quickfix/QuickFixUtil", "canFunctionOrGetterReturnExpression"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/core/quickfix/QuickFixUtil", "canFunctionOrGetterReturnExpression"));
        }
        if (functionOrGetter instanceof KtFunctionLiteral) {
            KtBlockExpression functionLiteralBody = ((KtFunctionLiteral)functionOrGetter).getBodyExpression();
            PsiElement returnedElement = functionLiteralBody == null ? null : functionLiteralBody.getLastChild();
            return returnedElement instanceof KtExpression && QuickFixUtil.canEvaluateTo((KtExpression)returnedElement, expression2);
        }
        if (functionOrGetter instanceof KtDeclarationWithInitializer && QuickFixUtil.canEvaluateTo(((KtDeclarationWithInitializer)functionOrGetter).getInitializer(), expression2)) {
            return true;
        }
        KtReturnExpression returnExpression = (KtReturnExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, KtReturnExpression.class);
        return returnExpression != null && QuickFixUtil.canEvaluateTo(returnExpression.getReturnedExpression(), expression2);
    }

    public static String renderTypeWithFqNameOnClash(KotlinType type2, String nameToCheckAgainst) {
        FqName typeFqName = DescriptorUtils.getFqNameSafe(DescriptorUtils.getClassDescriptorForType(type2));
        FqName fqNameToCheckAgainst = new FqName(nameToCheckAgainst);
        DescriptorRenderer renderer2 = typeFqName.shortName().equals(fqNameToCheckAgainst.shortName()) ? IdeDescriptorRenderers.SOURCE_CODE : IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES;
        return renderer2.renderType(type2);
    }
}

