/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.CachedAttributeData;
import org.jetbrains.kotlin.idea.caches.FileAttributeService;
import org.jetbrains.kotlin.idea.caches.JarUserDataManager;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u001b\u001c\u001d\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J3\u0010\u0017\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/caches/JarUserDataManager;", "", "()V", "fileAttributeService", "Lorg/jetbrains/kotlin/idea/caches/FileAttributeService;", "getFileAttributeService", "()Lorg/jetbrains/kotlin/idea/caches/FileAttributeService;", "version", "", "getVersion", "()I", "hasFileWithProperty", "", "counter", "Lorg/jetbrains/kotlin/idea/caches/JarUserDataManager$JarBooleanPropertyCounter;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lorg/jetbrains/kotlin/idea/caches/JarUserDataManager$JarBooleanPropertyCounter;Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/Boolean;", "register", "", "scheduleJarProcessing", "jarFile", "localJarFile", "storeUserData", "timestamp", "", "(Lorg/jetbrains/kotlin/idea/caches/JarUserDataManager$JarBooleanPropertyCounter;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Boolean;Ljava/lang/Long;)V", "JarBooleanPropertyCounter", "JarFileSystemUtil", "PropertyData", "State", "idea-analysis"})
public final class JarUserDataManager {
    private static final int version = 2;
    @Nullable
    private static final FileAttributeService fileAttributeService;
    public static final JarUserDataManager INSTANCE;

    public final int getVersion() {
        return version;
    }

    @Nullable
    public final FileAttributeService getFileAttributeService() {
        return fileAttributeService;
    }

    public final void register(@NotNull JarBooleanPropertyCounter counter) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)counter, (String)"counter");
            FileAttributeService fileAttributeService = JarUserDataManager.fileAttributeService;
            if (fileAttributeService == null) break block0;
            String string = counter.getKey().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"counter.key.toString()");
            fileAttributeService.register(string, version);
        }
    }

    @Nullable
    public final Boolean hasFileWithProperty(@NotNull JarBooleanPropertyCounter counter, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)counter, (String)"counter");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        VirtualFile virtualFile2 = JarFileSystemUtil.INSTANCE.findLocalJarFile(file2);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile localJarFile = virtualFile2;
        PropertyData stored = (PropertyData)localJarFile.getUserData(counter.getKey());
        if (stored != null && localJarFile.getTimeStamp() == stored.getTimestamp()) {
            return stored.getHasFileWithProperty();
        }
        if (stored == null && fileAttributeService != null) {
            String string = counter.getKey().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"counter.key.toString()");
            CachedAttributeData<State> savedData = fileAttributeService.readEnumAttribute(string, localJarFile, State.class);
            if (savedData != null) {
                boolean hasFileWithProperty2 = Intrinsics.areEqual((Object)((Object)savedData.getValue()), (Object)((Object)State.HAS_FILE));
                this.storeUserData(counter, localJarFile, hasFileWithProperty2, savedData.getTimeStamp());
                if (localJarFile.getTimeStamp() == savedData.getTimeStamp()) {
                    return hasFileWithProperty2;
                }
            }
        }
        VirtualFile virtualFile3 = JarFileSystemUtil.INSTANCE.findJarFileRoot(file2);
        if (virtualFile3 == null) {
            return null;
        }
        VirtualFile jarFileRoot = virtualFile3;
        this.scheduleJarProcessing(counter, jarFileRoot, localJarFile);
        return null;
    }

    private final void scheduleJarProcessing(JarBooleanPropertyCounter counter, VirtualFile jarFile, VirtualFile localJarFile) {
        PropertyData userData = (PropertyData)localJarFile.getUserData(counter.getKey());
        if (userData != null && localJarFile.getTimeStamp() == userData.getTimestamp()) {
            return;
        }
        JarUserDataManager.storeUserData$default(this, counter, localJarFile, null, null, 8, null);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(localJarFile, counter, jarFile){
            final /* synthetic */ VirtualFile $localJarFile;
            final /* synthetic */ JarBooleanPropertyCounter $counter;
            final /* synthetic */ VirtualFile $jarFile;

            public final void run() {
                ApplicationUtilsKt.runReadAction((Function0)new Function0<Unit>(this){
                    final /* synthetic */ scheduleJarProcessing.1 this$0;

                    public final void invoke() {
                        CachedAttributeData<Enum> cachedAttributeData;
                        PropertyData data = (PropertyData)this.this$0.$localJarFile.getUserData(this.this$0.$counter.getKey());
                        if (data != null && (data.getHasFileWithProperty() != null && this.this$0.$localJarFile.getTimeStamp() == data.getTimestamp() || !data.isProcessStarted().compareAndSet(false, true))) {
                            return;
                        }
                        boolean hasFileWithProperty2 = !VfsUtilCore.processFilesRecursively((VirtualFile)this.this$0.$jarFile, (Processor)((Processor)new Processor<VirtualFile>(this){
                            final /* synthetic */ scheduleJarProcessing.1 this$0;

                            public final boolean process(VirtualFile file2) {
                                JarBooleanPropertyCounter jarBooleanPropertyCounter = this.this$0.this$0.$counter;
                                VirtualFile virtualFile2 = file2;
                                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
                                return !jarBooleanPropertyCounter.hasProperty(virtualFile2);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }));
                        State state = hasFileWithProperty2 ? State.HAS_FILE : State.NO_FILE;
                        FileAttributeService fileAttributeService = JarUserDataManager.INSTANCE.getFileAttributeService();
                        if (fileAttributeService != null) {
                            String string = this.this$0.$counter.getKey().toString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"counter.key.toString()");
                            cachedAttributeData = fileAttributeService.writeEnumAttribute(string, this.this$0.$localJarFile, (Enum)state);
                        } else {
                            cachedAttributeData = null;
                        }
                        CachedAttributeData<Enum> savedData = cachedAttributeData;
                        CachedAttributeData<Enum> cachedAttributeData2 = savedData;
                        JarUserDataManager.access$storeUserData(JarUserDataManager.INSTANCE, this.this$0.$counter, this.this$0.$localJarFile, hasFileWithProperty2, cachedAttributeData2 != null ? Long.valueOf(cachedAttributeData2.getTimeStamp()) : Long.valueOf(this.this$0.$localJarFile.getTimeStamp()));
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.$localJarFile = virtualFile2;
                this.$counter = jarBooleanPropertyCounter;
                this.$jarFile = virtualFile3;
            }
        });
    }

    private final void storeUserData(JarBooleanPropertyCounter counter, VirtualFile localJarFile, Boolean hasFileWithProperty2, Long timestamp) {
        boolean bl = timestamp == null == (hasFileWithProperty2 == null);
        if (_Assertions.ENABLED && !bl) {
            String string = "Using empty timestamp is only allowed for storing not counted value";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Long l = timestamp;
        localJarFile.putUserData(counter.getKey(), (Object)new PropertyData(hasFileWithProperty2, l != null ? ((Number)l).longValue() : localJarFile.getTimeStamp(), new AtomicBoolean(false)));
    }

    static /* bridge */ /* synthetic */ void storeUserData$default(JarUserDataManager jarUserDataManager, JarBooleanPropertyCounter jarBooleanPropertyCounter, VirtualFile virtualFile2, Boolean bl, Long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: storeUserData");
        }
        if ((n & 8) != 0) {
            l = null;
        }
        jarUserDataManager.storeUserData(jarBooleanPropertyCounter, virtualFile2, bl, l);
    }

    private JarUserDataManager() {
        INSTANCE = this;
        version = 2;
        fileAttributeService = (FileAttributeService)ServiceManager.getService(FileAttributeService.class);
    }

    static {
        new JarUserDataManager();
    }

    public static final /* synthetic */ void access$storeUserData(JarUserDataManager $this, @NotNull JarBooleanPropertyCounter counter, @NotNull VirtualFile localJarFile, @Nullable Boolean hasFileWithProperty2, @Nullable Long timestamp) {
        $this.storeUserData(counter, localJarFile, hasFileWithProperty2, timestamp);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/caches/JarUserDataManager$State;", "", "(Ljava/lang/String;I)V", "INIT", "HAS_FILE", "NO_FILE", "idea-analysis"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State INIT;
        public static final /* enum */ State HAS_FILE;
        public static final /* enum */ State NO_FILE;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = INIT = new State();
            stateArray[1] = HAS_FILE = new State();
            stateArray[2] = NO_FILE = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/caches/JarUserDataManager$JarFileSystemUtil;", "", "()V", "findJarFileRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "inJarFile", "findLocalJarFile", "idea-analysis"})
    public static final class JarFileSystemUtil {
        public static final JarFileSystemUtil INSTANCE;

        @Nullable
        public final VirtualFile findJarFileRoot(@NotNull VirtualFile inJarFile) {
            Intrinsics.checkParameterIsNotNull((Object)inJarFile, (String)"inJarFile");
            if (!StringsKt.startsWith$default((String)inJarFile.getUrl(), (String)"jar://", (boolean)false, (int)2, null)) {
                return null;
            }
            VirtualFile jarFile = inJarFile;
            while (jarFile.getParent() != null) {
                Intrinsics.checkExpressionValueIsNotNull((Object)jarFile.getParent(), (String)"jarFile.parent");
            }
            return jarFile;
        }

        @Nullable
        public final VirtualFile findLocalJarFile(@NotNull VirtualFile inJarFile) {
            Intrinsics.checkParameterIsNotNull((Object)inJarFile, (String)"inJarFile");
            if (!StringsKt.startsWith$default((String)inJarFile.getUrl(), (String)"jar://", (boolean)false, (int)2, null)) {
                return null;
            }
            String path = inJarFile.getPath();
            int jarSeparatorIndex = StringsKt.indexOf$default((CharSequence)path, (String)"!/", (int)0, (boolean)false, (int)6, null);
            boolean bl = jarSeparatorIndex >= 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "Path passed to JarFileSystem must have jar separator '!/': " + path;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            String string = path;
            int n = 0;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, jarSeparatorIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String localPath = string3;
            return StandardFileSystems.local().findFileByPath(localPath);
        }

        private JarFileSystemUtil() {
            INSTANCE = this;
        }

        static {
            new JarFileSystemUtil();
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J.\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/caches/JarUserDataManager$PropertyData;", "", "hasFileWithProperty", "", "timestamp", "", "isProcessStarted", "Ljava/util/concurrent/atomic/AtomicBoolean;", "(Ljava/lang/Boolean;JLjava/util/concurrent/atomic/AtomicBoolean;)V", "getHasFileWithProperty", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "getTimestamp", "()J", "component1", "component2", "component3", "copy", "(Ljava/lang/Boolean;JLjava/util/concurrent/atomic/AtomicBoolean;)Lorg/jetbrains/kotlin/idea/caches/JarUserDataManager$PropertyData;", "idea-analysis"})
    public static final class PropertyData {
        @Nullable
        private final Boolean hasFileWithProperty;
        private final long timestamp;
        @NotNull
        private final AtomicBoolean isProcessStarted;

        @Nullable
        public final Boolean getHasFileWithProperty() {
            return this.hasFileWithProperty;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final AtomicBoolean isProcessStarted() {
            return this.isProcessStarted;
        }

        public PropertyData(@Nullable Boolean hasFileWithProperty2, long timestamp, @NotNull AtomicBoolean isProcessStarted) {
            Intrinsics.checkParameterIsNotNull((Object)isProcessStarted, (String)"isProcessStarted");
            this.hasFileWithProperty = hasFileWithProperty2;
            this.timestamp = timestamp;
            this.isProcessStarted = isProcessStarted;
        }

        @Nullable
        public final Boolean component1() {
            return this.hasFileWithProperty;
        }

        public final long component2() {
            return this.timestamp;
        }

        @NotNull
        public final AtomicBoolean component3() {
            return this.isProcessStarted;
        }

        @NotNull
        public final PropertyData copy(@Nullable Boolean hasFileWithProperty2, long timestamp, @NotNull AtomicBoolean isProcessStarted) {
            Intrinsics.checkParameterIsNotNull((Object)isProcessStarted, (String)"isProcessStarted");
            return new PropertyData(hasFileWithProperty2, timestamp, isProcessStarted);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ PropertyData copy$default(PropertyData propertyData, Boolean bl, long l, AtomicBoolean atomicBoolean, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                bl = propertyData.hasFileWithProperty;
            }
            if ((n & 2) != 0) {
                l = propertyData.timestamp;
            }
            if ((n & 4) != 0) {
                atomicBoolean = propertyData.isProcessStarted;
            }
            return propertyData.copy(bl, l, atomicBoolean);
        }

        public String toString() {
            return "PropertyData(hasFileWithProperty=" + this.hasFileWithProperty + ", timestamp=" + this.timestamp + ", isProcessStarted=" + this.isProcessStarted + ")";
        }

        public int hashCode() {
            Boolean bl = this.hasFileWithProperty;
            long l = this.timestamp;
            AtomicBoolean atomicBoolean = this.isProcessStarted;
            return ((bl != null ? ((Object)bl).hashCode() : 0) * 31 + (int)(l ^ l >>> 32)) * 31 + (atomicBoolean != null ? atomicBoolean.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PropertyData)) break block3;
                    PropertyData propertyData = (PropertyData)object;
                    if (!Intrinsics.areEqual((Object)this.hasFileWithProperty, (Object)propertyData.hasFileWithProperty) || !(this.timestamp == propertyData.timestamp) || !Intrinsics.areEqual((Object)this.isProcessStarted, (Object)propertyData.isProcessStarted)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/caches/JarUserDataManager$JarBooleanPropertyCounter;", "", "keyName", "", "(Ljava/lang/String;)V", "key", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/kotlin/idea/caches/JarUserDataManager$PropertyData;", "getKey", "()Lcom/intellij/openapi/util/Key;", "hasProperty", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "toString", "idea-analysis"})
    public static abstract class JarBooleanPropertyCounter {
        @NotNull
        private final Key<PropertyData> key;

        @NotNull
        public final Key<PropertyData> getKey() {
            return this.key;
        }

        public abstract boolean hasProperty(@NotNull VirtualFile var1);

        @NotNull
        public String toString() {
            return "Counter: " + this.key;
        }

        public JarBooleanPropertyCounter(@NotNull String keyName) {
            Intrinsics.checkParameterIsNotNull((Object)keyName, (String)"keyName");
            Key key = Key.create((String)keyName);
            Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<PropertyData>(keyName)");
            this.key = key;
        }
    }
}

