/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.internal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffPanel;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.diff.ex.DiffPanelOptions;
import com.intellij.openapi.diff.impl.DiffPanelImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.actions.internal.CheckPartialBodyResolveAction;
import org.jetbrains.kotlin.idea.actions.internal.KotlinInternalMode;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ)\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J*\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u0019H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010#\u001a\u0004\u0018\u00010 *\u00020$H\u0002J\f\u0010%\u001a\u00020\u0016*\u00020&H\u0002J\f\u0010%\u001a\u00020\u0016*\u00020'H\u0002\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/CheckPartialBodyResolveAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "allFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "filesOrDirs", "", "([Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/util/Collection;", "allKotlinFiles", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "([Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)Lkotlin/sequences/Sequence;", "checkResolve", "files", "dumpResolve", "", "file", "resolver", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isValueNeeded", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "selectedKotlinFiles", "update", "lastStatement", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "presentation", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/types/KotlinType;", "idea"})
public final class CheckPartialBodyResolveAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        List selectedFiles = SequencesKt.toList(this.selectedKotlinFiles(e));
        Object object = CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Project project = (Project)object;
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(this, selectedFiles, project){
            final /* synthetic */ CheckPartialBodyResolveAction this$0;
            final /* synthetic */ List $selectedFiles;
            final /* synthetic */ Project $project;

            public final void run() {
                ApplicationUtilsKt.runReadAction((Function0)new Function0<Unit>(this){
                    final /* synthetic */ actionPerformed.1 this$0;

                    public final void invoke() {
                        CheckPartialBodyResolveAction checkPartialBodyResolveAction = this.this$0.this$0;
                        Collection collection = this.this$0.$selectedFiles;
                        Project project = this.this$0.$project;
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                        CheckPartialBodyResolveAction.access$checkResolve(checkPartialBodyResolveAction, collection, project);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = checkPartialBodyResolveAction;
                this.$selectedFiles = list2;
                this.$project = project;
            }
        }, "Checking Partial Body Resolve", true, project);
    }

    private final void checkResolve(Collection<? extends KtFile> files2, Project project) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)files2)) {
            int i = indexedValue.component1();
            KtFile file2 = (KtFile)indexedValue.component2();
            ProgressIndicator progressIndicator2 = progressIndicator;
            if (progressIndicator2 != null) {
                progressIndicator2.setText("Checking resolve " + i + " of " + files2.size() + "...");
            }
            ProgressIndicator progressIndicator3 = progressIndicator;
            if (progressIndicator3 != null) {
                progressIndicator3.setText2(file2.getVirtualFile().getPath());
            }
            String partialResolveDump2 = this.dumpResolve(file2, (Function2<? super KtElement, ? super ResolutionFacade, ? extends BindingContext>)((Function2)checkResolve.partialResolveDump.1.INSTANCE));
            String goldDump2 = this.dumpResolve(file2, (Function2<? super KtElement, ? super ResolutionFacade, ? extends BindingContext>)((Function2)checkResolve.goldDump.1.INSTANCE));
            if (Intrinsics.areEqual((Object)partialResolveDump2, (Object)goldDump2) ^ true) {
                SwingUtilities.invokeLater(new Runnable(file2, project, goldDump2, partialResolveDump2){
                    final /* synthetic */ KtFile $file;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ String $goldDump;
                    final /* synthetic */ String $partialResolveDump;

                    public final void run() {
                        String title = "Difference Found in File " + this.$file.getVirtualFile().getPath();
                        SimpleDiffRequest request = new SimpleDiffRequest(this.$project, title);
                        request.setContents((DiffContent)new SimpleContent(this.$goldDump), (DiffContent)new SimpleContent(this.$partialResolveDump));
                        request.setContentTitles("Expected", "Partial Body Resolve");
                        DialogBuilder diffBuilder = new DialogBuilder(this.$project);
                        DiffPanel diffPanel = DiffManager.getInstance().createDiffPanel(diffBuilder.getWindow(), this.$project, (Disposable)diffBuilder, (DiffTool)null);
                        if (diffPanel == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.diff.impl.DiffPanelImpl");
                        }
                        DiffPanelImpl diffPanel2 = (DiffPanelImpl)diffPanel;
                        diffPanel2.getOptions().setShowSourcePolicy(DiffPanelOptions.ShowSourcePolicy.DONT_SHOW);
                        diffBuilder.setCenterPanel(diffPanel2.getComponent());
                        diffBuilder.setDimensionServiceKey("org.jetbrains.kotlin.idea.actions.internal.CheckPartialBodyResolveAction.Diff");
                        diffPanel2.setDiffRequest((DiffRequest)request);
                        diffBuilder.addOkAction().setText("Close");
                        diffBuilder.setTitle(title);
                        diffBuilder.showNotModal();
                    }
                    {
                        this.$file = ktFile;
                        this.$project = project;
                        this.$goldDump = string;
                        this.$partialResolveDump = string2;
                    }
                });
                return;
            }
            ProgressIndicator progressIndicator4 = progressIndicator;
            if (progressIndicator4 == null) continue;
            progressIndicator4.setFraction((double)(i + 1) / (double)files2.size());
        }
        SwingUtilities.invokeLater(new Runnable(project, files2){
            final /* synthetic */ Project $project;
            final /* synthetic */ Collection $files;

            public final void run() {
                Messages.showInfoMessage((Project)this.$project, (String)("Analyzed " + this.$files.size() + " file(s). No resolve difference found. "), (String)"Success");
            }
            {
                this.$project = project;
                this.$files = collection;
            }
        });
    }

    private final String dumpResolve(KtFile file2, Function2<? super KtElement, ? super ResolutionFacade, ? extends BindingContext> resolver) {
        StringBuilder builder = new StringBuilder();
        ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade(file2);
        Document document = FileDocumentManager.getInstance().getDocument(file2.getVirtualFile());
        if (document == null) {
            Intrinsics.throwNpe();
        }
        Document document2 = document;
        file2.acceptChildren(new KtVisitorVoid(this, resolver, resolutionFacade, document2, builder){
            final /* synthetic */ CheckPartialBodyResolveAction this$0;
            final /* synthetic */ Function2 $resolver;
            final /* synthetic */ ResolutionFacade $resolutionFacade;
            final /* synthetic */ Document $document;
            final /* synthetic */ StringBuilder $builder;

            public void visitKtElement(@NotNull KtElement element2) {
                Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                ProgressManager.checkCanceled();
                element2.acceptChildren(this);
            }

            public void visitExpression(@NotNull KtExpression expression2) {
                KotlinType type2;
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitExpression(expression2);
                if (expression2 instanceof KtDeclaration) {
                    return;
                }
                if (!CheckPartialBodyResolveAction.access$isValueNeeded(this.this$0, expression2)) {
                    return;
                }
                BindingContext bindingContext2 = (BindingContext)this.$resolver.invoke((Object)expression2, (Object)this.$resolutionFacade);
                int offset2 = expression2.getTextOffset();
                int line = this.$document.getLineNumber(offset2);
                int column = offset2 - this.$document.getLineStartOffset(line);
                KtExpression ktExpression = expression2;
                if (!(ktExpression instanceof KtNameReferenceExpression)) {
                    ktExpression = null;
                }
                if ((object = (KtNameReferenceExpression)ktExpression) == null || (object = ((KtNameReferenceExpression)object).getReferencedName()) == null) {
                    object = expression2.getClass().getSimpleName();
                }
                Object exprName = object;
                this.$builder.append((String)exprName + " at (" + (line + 1) + ":" + (column + 1) + ")");
                if (expression2 instanceof KtReferenceExpression) {
                    DeclarationDescriptor target = (DeclarationDescriptor)bindingContext2.get(BindingContext.REFERENCE_TARGET, expression2);
                    DeclarationDescriptor declarationDescriptor = target;
                    this.$builder.append(" resolves to " + (declarationDescriptor != null ? CheckPartialBodyResolveAction.access$presentation(this.this$0, declarationDescriptor) : null));
                }
                if ((type2 = bindingContext2.getType(expression2)) != null) {
                    this.$builder.append(" has type " + CheckPartialBodyResolveAction.access$presentation(this.this$0, type2));
                }
                this.$builder.append("\n");
            }
            {
                this.this$0 = $outer;
                this.$resolver = $captured_local_variable$1;
                this.$resolutionFacade = $captured_local_variable$2;
                this.$document = $captured_local_variable$3;
                this.$builder = $captured_local_variable$4;
            }
        });
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    private final String presentation(@NotNull DeclarationDescriptor $receiver) {
        return DescriptorRenderer.FQ_NAMES_IN_TYPES.render($receiver);
    }

    private final String presentation(@NotNull KotlinType $receiver) {
        return DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType($receiver);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (!KotlinInternalMode.Instance.getEnabled()) {
            e.getPresentation().setVisible(false);
            e.getPresentation().setEnabled(false);
        } else {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(SequencesKt.any(this.selectedKotlinFiles(e)));
        }
    }

    private final Sequence<KtFile> selectedKotlinFiles(AnActionEvent e) {
        Project project;
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return SequencesKt.sequenceOf((Object[])new KtFile[0]);
        }
        VirtualFile[] virtualFiles = virtualFileArray;
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project2 == null) {
            return SequencesKt.sequenceOf((Object[])new KtFile[0]);
        }
        Project project3 = project = project2;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        return this.allKotlinFiles(virtualFiles, project3);
    }

    private final Sequence<KtFile> allKotlinFiles(VirtualFile[] filesOrDirs, Project project) {
        PsiManager manager = PsiManager.getInstance((Project)project);
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.allFiles(filesOrDirs)), (Function1)((Function1)new Function1<VirtualFile, KtFile>(manager){
            final /* synthetic */ PsiManager $manager;

            @Nullable
            public final KtFile invoke(@NotNull VirtualFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                PsiFile psiFile = this.$manager.findFile(it);
                if (!(psiFile instanceof KtFile)) {
                    psiFile = null;
                }
                return (KtFile)psiFile;
            }
            {
                this.$manager = psiManager;
                super(1);
            }
        }));
    }

    private final Collection<VirtualFile> allFiles(VirtualFile[] filesOrDirs) {
        ArrayList result2 = new ArrayList();
        for (int i = 0; i < filesOrDirs.length; ++i) {
            VirtualFile file2 = filesOrDirs[i];
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Unit>(result2, new VirtualFileVisitor.Option[0]){
                final /* synthetic */ ArrayList $result;

                public boolean visitFile(@NotNull VirtualFile file2) {
                    Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                    this.$result.add(file2);
                    return true;
                }
                {
                    this.$result = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            }));
        }
        return result2;
    }

    private final boolean isValueNeeded(KtExpression expression2) {
        boolean bl;
        PsiElement parent2 = expression2.getParent();
        PsiElement psiElement = parent2;
        if (psiElement instanceof KtBlockExpression) {
            bl = Intrinsics.areEqual((Object)expression2, (Object)this.lastStatement((KtBlockExpression)parent2)) && this.isValueNeeded((KtExpression)parent2);
        } else if (psiElement instanceof KtContainerNode) {
            KtExpression pparent;
            PsiElement psiElement2 = parent2.getParent();
            if (!(psiElement2 instanceof KtExpression)) {
                psiElement2 = null;
            }
            bl = (pparent = (KtExpression)psiElement2) != null && this.isValueNeeded(pparent);
        } else {
            bl = psiElement instanceof KtDeclarationWithBody ? (Intrinsics.areEqual((Object)expression2, (Object)((KtDeclarationWithBody)parent2).getBodyExpression()) ? !((KtDeclarationWithBody)parent2).hasBlockBody() && !((KtDeclarationWithBody)parent2).hasDeclaredReturnType() : true) : true;
        }
        return bl;
    }

    private final KtExpression lastStatement(@NotNull KtBlockExpression $receiver) {
        KtExpression ktExpression;
        PsiElement psiElement = $receiver.getLastChild();
        if (psiElement != null && (psiElement = PsiUtilsKt.siblings$default(psiElement, false, false, 2, null)) != null) {
            Object v1;
            block3: {
                PsiElement $receiver$iv = psiElement;
                for (Object element$iv : $receiver$iv) {
                    if (!(element$iv instanceof KtExpression)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            ktExpression = v1;
        } else {
            ktExpression = null;
        }
        return ktExpression;
    }

    public static final /* synthetic */ void access$checkResolve(CheckPartialBodyResolveAction $this, @NotNull Collection files2, @NotNull Project project) {
        $this.checkResolve(files2, project);
    }

    public static final /* synthetic */ boolean access$isValueNeeded(CheckPartialBodyResolveAction $this, @NotNull KtExpression expression2) {
        return $this.isValueNeeded(expression2);
    }

    @NotNull
    public static final /* synthetic */ String access$presentation(CheckPartialBodyResolveAction $this, @NotNull DeclarationDescriptor $receiver) {
        return $this.presentation($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$presentation(CheckPartialBodyResolveAction $this, @NotNull KotlinType $receiver) {
        return $this.presentation($receiver);
    }
}

