/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreterKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.ProgressionIteratorBasicValue;
import org.jetbrains.kotlin.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0014J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0016J \u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019H\u0017J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\bH\u0014J\u0018\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0014J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\bH\u0014J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\bH\u0014J \u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u000eH\u0014J\u001a\u0010!\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\nH\u0017R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxingInterpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter;", "insnList", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "(Lorg/jetbrains/org/objectweb/asm/tree/InsnList;)V", "boxingPlaces", "Ljava/util/HashMap;", "", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue;", "createNewBoxing", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "progressionIterator", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue;", "isExactValue", "", "value", "merge", "v", "w", "naryOperation", "values", "", "onMergeFail", "", "onMergeSuccess", "onMethodCallWithBoxedValue", "onNewBoxedValue", "onUnboxing", "resultType", "unaryOperation", "backend"})
public class BoxingInterpreter
extends OptimizationBasicInterpreter {
    private final HashMap<Integer, BoxedBasicValue> boxingPlaces;
    private final InsnList insnList;

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected BasicValue createNewBoxing(@NotNull AbstractInsnNode insn, @NotNull Type type2, @Nullable ProgressionIteratorBasicValue progressionIterator) {
        Object object;
        void key$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        int index2 = this.insnList.indexOf(insn);
        Map map2 = this.boxingPlaces;
        Integer n = index2;
        Object value$iv = $receiver$iv.get(key$iv);
        if (value$iv == null) {
            BoxedBasicValue boxedBasicValue = new BoxedBasicValue(type2, insn, progressionIterator);
            this.onNewBoxedValue(boxedBasicValue);
            BoxedBasicValue answer$iv = boxedBasicValue;
            $receiver$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (BasicValue)object;
    }

    @Override
    @Nullable
    public BasicValue naryOperation(@NotNull AbstractInsnNode insn, @NotNull List<? extends BasicValue> values) throws AnalyzerException {
        BasicValue basicValue;
        Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        BasicValue value2 = super.naryOperation(insn, values);
        BasicValue basicValue2 = (BasicValue)CollectionsKt.firstOrNull(values);
        if (basicValue2 == null) {
            return value2;
        }
        BasicValue firstArg = basicValue2;
        if (BoxingInterpreterKt.isBoxing(insn)) {
            Type type2 = value2.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"value.type");
            basicValue = this.createNewBoxing(insn, type2, null);
        } else if (BoxingInterpreterKt.isUnboxing(insn) && firstArg instanceof BoxedBasicValue) {
            BoxedBasicValue boxedBasicValue = (BoxedBasicValue)firstArg;
            Type type3 = value2.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"value.type");
            this.onUnboxing(insn, boxedBasicValue, type3);
            basicValue = value2;
        } else if (BoxingInterpreterKt.access$isIteratorMethodCallOfProgression(insn, values)) {
            String string = firstArg.getType().getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"firstArg.type.internalName");
            basicValue = new ProgressionIteratorBasicValue(BoxingInterpreterKt.access$getValuesTypeOfProgressionClass(string));
        } else if (BoxingInterpreterKt.access$isNextMethodCallOfProgressionIterator(insn, values)) {
            BasicValue basicValue3 = firstArg;
            if (!(basicValue3 instanceof ProgressionIteratorBasicValue)) {
                basicValue3 = null;
            }
            ProgressionIteratorBasicValue progressionIteratorBasicValue = (ProgressionIteratorBasicValue)basicValue3;
            if (progressionIteratorBasicValue == null) {
                throw (Throwable)((Object)new AssertionError((Object)"firstArg should be progression iterator"));
            }
            ProgressionIteratorBasicValue progressionIteratorBasicValue2 = progressionIteratorBasicValue;
            Type type4 = AsmUtil.boxType(progressionIteratorBasicValue2.getValuesPrimitiveType());
            Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"AsmUtil.boxType(progress\u2026ator.valuesPrimitiveType)");
            basicValue = this.createNewBoxing(insn, type4, progressionIteratorBasicValue2);
        } else {
            for (BasicValue basicValue4 : values) {
                if (!(basicValue4 instanceof BoxedBasicValue)) continue;
                this.onMethodCallWithBoxedValue((BoxedBasicValue)basicValue4);
            }
            basicValue = value2;
        }
        return basicValue;
    }

    @Override
    @Nullable
    public BasicValue unaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value2) throws AnalyzerException {
        Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        return insn.getOpcode() == 192 && this.isExactValue(value2) ? value2 : super.unaryOperation(insn, value2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isExactValue(@NotNull BasicValue value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        if (value2 instanceof ProgressionIteratorBasicValue) return true;
        if (value2 instanceof BoxedBasicValue) return true;
        if (value2.getType() == null) return false;
        String string = value2.getType().getInternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.type.internalName");
        if (!BoxingInterpreterKt.access$isProgressionClass(string)) return false;
        return true;
    }

    @Override
    @NotNull
    public BasicValue merge(@NotNull BasicValue v, @NotNull BasicValue w) {
        BasicValue basicValue;
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        Intrinsics.checkParameterIsNotNull((Object)w, (String)"w");
        if (Intrinsics.areEqual((Object)v, (Object)((Object)StrictBasicValue.UNINITIALIZED_VALUE)) || Intrinsics.areEqual((Object)w, (Object)((Object)StrictBasicValue.UNINITIALIZED_VALUE))) {
            basicValue = StrictBasicValue.UNINITIALIZED_VALUE;
        } else if (v instanceof BoxedBasicValue && ((BoxedBasicValue)v).typeEquals(w)) {
            BasicValue basicValue2 = w;
            if (basicValue2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            }
            this.onMergeSuccess((BoxedBasicValue)v, (BoxedBasicValue)basicValue2);
            basicValue = v;
        } else {
            if (v instanceof BoxedBasicValue) {
                this.onMergeFail((BoxedBasicValue)v);
            }
            if (w instanceof BoxedBasicValue) {
                this.onMergeFail((BoxedBasicValue)w);
            }
            BasicValue basicValue3 = super.merge(v, w);
            basicValue = basicValue3;
            Intrinsics.checkExpressionValueIsNotNull((Object)basicValue3, (String)"super.merge(v, w)");
        }
        return basicValue;
    }

    protected void onNewBoxedValue(@NotNull BoxedBasicValue value2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value2), (String)"value");
    }

    protected void onUnboxing(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value2, @NotNull Type resultType) {
        Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
        Intrinsics.checkParameterIsNotNull((Object)((Object)value2), (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)resultType, (String)"resultType");
    }

    protected void onMethodCallWithBoxedValue(@NotNull BoxedBasicValue value2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value2), (String)"value");
    }

    protected void onMergeFail(@NotNull BoxedBasicValue value2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value2), (String)"value");
    }

    protected void onMergeSuccess(@NotNull BoxedBasicValue v, @NotNull BoxedBasicValue w) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)v), (String)"v");
        Intrinsics.checkParameterIsNotNull((Object)((Object)w), (String)"w");
    }

    public BoxingInterpreter(@NotNull InsnList insnList) {
        Intrinsics.checkParameterIsNotNull((Object)insnList, (String)"insnList");
        this.insnList = insnList;
        this.boxingPlaces = new HashMap();
    }
}

