/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.server;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.deployment.DeploymentMethod;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.oss.jboss.JBossBundle;
import com.intellij.javaee.oss.jboss.server.JBossDeploymentProvider;
import com.intellij.javaee.oss.jboss.server.JBossRemoteEditor;
import com.intellij.javaee.oss.jboss.server.JBossServerModel;
import com.intellij.javaee.oss.jboss.version.JBossContributionsProvider;
import com.intellij.javaee.oss.jboss.version.JBossVersion6Handler;
import com.intellij.javaee.oss.jboss.version.JBossVersion7Handler;
import com.intellij.javaee.oss.jboss.version.JBossVersionContribution;
import com.intellij.javaee.oss.transport.SimpleRemoteServerModel;
import com.intellij.javaee.oss.transport.SimpleRemoteServerModelData;
import com.intellij.javaee.oss.transport.SimpleRemoteServerModelDelegate;
import com.intellij.javaee.oss.util.Version;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.transport.TransportTarget;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class JBossRemoteModel
extends JBossServerModel
implements SimpleRemoteServerModel {
    @NonNls
    private static final String DATA_ELEMENT = "data";
    public static final int DEFAULT_JNDI_PORT = 1099;
    public static final int DEFAULT_MANAGEMENT_PORT = 9999;
    public int JNDI_PORT = 1099;
    public int MANAGEMENT_PORT = 9999;
    private SimpleRemoteServerModelDelegate myTransportDelegate = new SimpleRemoteServerModelDelegate().init((SimpleRemoteServerModel)this);
    private JBossContributionsProvider<RemoteModelContribution> myContributionsProvider;

    public JBossRemoteModel() {
        this.initRemote();
    }

    private void initRemote() {
        this.myContributionsProvider = new JBossContributionsProvider<RemoteModelContribution>(RemoteModelContribution.class);
        this.myContributionsProvider.add(JBossVersion6Handler.ID, new RemoteModelContribution(){

            @Override
            public void checkConfiguration() throws RuntimeConfigurationException {
                if (JBossRemoteModel.this.JNDI_PORT <= 0) {
                    throw new RuntimeConfigurationError(JBossBundle.getText("JBossRemoteModel.error.jmx", new Object[0]));
                }
            }

            @Override
            public int getServerPort() {
                return JBossRemoteModel.this.JNDI_PORT;
            }
        });
        this.myContributionsProvider.add(JBossVersion7Handler.ID, new RemoteModelContribution(){

            @Override
            public void checkConfiguration() throws RuntimeConfigurationException {
                if (JBossRemoteModel.this.MANAGEMENT_PORT <= 0) {
                    throw new RuntimeConfigurationError(JBossBundle.getText("JBossRemoteModel.error.management", new Object[0]));
                }
                if (JBossRemoteModel.this.isDomain() && StringUtil.isEmpty((String)JBossRemoteModel.this.getServerGroup())) {
                    throw new RuntimeConfigurationError(JBossBundle.getText("JBossServerModel.error.server.group", new Object[0]));
                }
                JBossRemoteModel.this.checkProcessJdk();
            }

            @Override
            public int getServerPort() {
                return JBossRemoteModel.this.MANAGEMENT_PORT;
            }
        });
        this.myContributionsProvider.addDefault(new RemoteModelContribution(){

            @Override
            public void checkConfiguration() throws RuntimeConfigurationException {
            }

            @Override
            public int getServerPort() {
                return 0;
            }
        });
    }

    public SettingsEditor<CommonModel> getEditor() {
        return new JBossRemoteEditor();
    }

    public String getTransportHostId() {
        return this.myTransportDelegate.getTransportHostId();
    }

    public void setTransportHostId(String transportHostId) {
        this.myTransportDelegate.setTransportHostId(transportHostId);
    }

    public TransportTarget getTransportStagingTarget() {
        return this.myTransportDelegate.getTransportStagingTarget();
    }

    public void setTransportStagingTarget(TransportTarget transportStagingTarget) {
        this.myTransportDelegate.setTransportStagingTarget(transportStagingTarget);
    }

    public String getStagingRemotePath() {
        return this.myTransportDelegate.getStagingRemotePath();
    }

    public void setStagingRemotePath(String stagingRemotePath) {
        this.myTransportDelegate.setStagingRemotePath(stagingRemotePath);
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        this.getContribution(this.myContributionsProvider).checkConfiguration();
        CommonModel commonModel = this.getCommonModel();
        boolean hasStagingMethod = false;
        for (DeploymentModel model : commonModel.getDeploymentModels()) {
            DeploymentMethod method = model.getDeploymentMethod();
            if (method == JBossDeploymentProvider.STAGING) {
                hasStagingMethod = true;
                continue;
            }
            if (method != JBossDeploymentProvider.NATIVE) continue;
            if (new Version(this.getVersion()).compare(7, 1, 0) < 0) {
                throw new RuntimeConfigurationError(JBossBundle.getText("JBossServerModel.error.deployment.method.version", new Object[0]));
            }
            File sourceFile = model.getDeploymentSource().getFile();
            if (sourceFile == null || !sourceFile.isDirectory()) continue;
            throw new RuntimeConfigurationError(JBossBundle.getText("JBossServerModel.error.artifact.type", new Object[0]));
        }
        if (hasStagingMethod) {
            this.myTransportDelegate.checkConfiguration();
        }
        super.checkConfiguration();
    }

    public boolean isDeployAllowed() {
        return this.myTransportDelegate.isDeployAllowed();
    }

    protected int getServerPort() {
        return this.getContribution(this.myContributionsProvider).getServerPort();
    }

    public String prepareDeployment(String sourcePath, boolean prepareNameOnly) throws RuntimeConfigurationException {
        return this.myTransportDelegate.prepareDeployment(sourcePath, prepareNameOnly);
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element dataElement = element.getChild(DATA_ELEMENT);
        if (dataElement == null) {
            super.readExternal(element);
        } else {
            JBossRemoteModelData settings = (JBossRemoteModelData)((Object)XmlSerializer.deserialize((Element)dataElement, JBossRemoteModelData.class));
            if (settings == null) {
                return;
            }
            this.myTransportDelegate.readFromData((SimpleRemoteServerModelData)settings);
            this.MANAGEMENT_PORT = settings.getManagementPort();
            this.JNDI_PORT = settings.getJndiPort();
            this.USERNAME = settings.getUsername();
            this.PASSWORD = settings.getPassword();
            this.DOMAIN = settings.isDomain();
            this.SERVER_GROUP = settings.getServerGroup();
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        JBossRemoteModelData settings = new JBossRemoteModelData();
        this.myTransportDelegate.writeToData((SimpleRemoteServerModelData)settings);
        settings.setManagementPort(this.MANAGEMENT_PORT);
        settings.setJndiPort(this.JNDI_PORT);
        settings.setUsername(this.USERNAME);
        settings.setPassword(this.PASSWORD);
        settings.setDomain(this.DOMAIN);
        settings.setServerGroup(this.SERVER_GROUP);
        Element dataElement = XmlSerializer.serialize((Object)((Object)settings), (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        element.addContent(dataElement);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        JBossRemoteModel result = (JBossRemoteModel)((Object)super.clone());
        result.initRemote();
        result.myTransportDelegate = ((SimpleRemoteServerModelDelegate)this.myTransportDelegate.clone()).init((SimpleRemoteServerModel)result);
        return result;
    }

    @Tag(value="data")
    public static class JBossRemoteModelData
    extends SimpleRemoteServerModelData {
        @Tag(value="username")
        private String myUsername = JBossServerModel.doGetDefaultUsername();
        @Tag(value="password")
        private String myPassword = JBossServerModel.doGetDefaultPassword();
        @Tag(value="jndi-port")
        private int myJndiPort = 1099;
        @Tag(value="management-port")
        private int myManagementPort = 9999;
        @Tag(value="domain")
        private boolean myDomain = false;
        @Tag(value="server-group")
        private String myServerGroup;

        public int getJndiPort() {
            return this.myJndiPort;
        }

        public void setJndiPort(int jndiPort) {
            this.myJndiPort = jndiPort;
        }

        public int getManagementPort() {
            return this.myManagementPort;
        }

        public void setManagementPort(int managementPort) {
            this.myManagementPort = managementPort;
        }

        public String getUsername() {
            return this.myUsername;
        }

        public void setUsername(String username) {
            this.myUsername = username;
        }

        public String getPassword() {
            return this.myPassword;
        }

        public void setPassword(String password) {
            this.myPassword = password;
        }

        public boolean isDomain() {
            return this.myDomain;
        }

        public void setDomain(boolean domain) {
            this.myDomain = domain;
        }

        public String getServerGroup() {
            return this.myServerGroup;
        }

        public void setServerGroup(String serverGroup) {
            this.myServerGroup = serverGroup;
        }
    }

    private static interface RemoteModelContribution
    extends JBossVersionContribution {
        public void checkConfiguration() throws RuntimeConfigurationException;

        public int getServerPort();
    }
}

