/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.server;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.oss.jboss.JBossBundle;
import com.intellij.javaee.oss.jboss.config.JBoss7PortConfig;
import com.intellij.javaee.oss.jboss.config.JBossBindingConfig;
import com.intellij.javaee.oss.jboss.config.JBossConfigProcessor;
import com.intellij.javaee.oss.jboss.config.JBossPortConfig;
import com.intellij.javaee.oss.jboss.config.Jboss7DomainHostConfig;
import com.intellij.javaee.oss.jboss.config.Jboss7DomainServersConfig;
import com.intellij.javaee.oss.jboss.server.JBossLocalEditor;
import com.intellij.javaee.oss.jboss.server.JBossServerModel;
import com.intellij.javaee.oss.jboss.version.JBossContributionsProvider;
import com.intellij.javaee.oss.jboss.version.JBossVersion6Handler;
import com.intellij.javaee.oss.jboss.version.JBossVersion7Handler;
import com.intellij.javaee.oss.jboss.version.JBossVersionContribution;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class JBossLocalModel
extends JBossServerModel {
    @NonNls
    public String SERVER = "";
    public String BINDING_SET_NAME = "";
    private JBossContributionsProvider<LocalModelContribution> myContributionsProvider;

    public JBossLocalModel() {
        this.initLocal();
    }

    private void initLocal() {
        this.myContributionsProvider = new JBossContributionsProvider<LocalModelContribution>(LocalModelContribution.class);
        this.myContributionsProvider.add(JBossVersion6Handler.ID, new LocalModelContribution(){

            @Override
            public void checkConfiguration() throws RuntimeConfigurationException {
                if (StringUtil.isEmpty((String)JBossLocalModel.this.SERVER)) {
                    throw new RuntimeConfigurationError(JBossBundle.getText("JBossLocalModel.error.missing", new Object[0]));
                }
                JBossPortConfig.checkOffset(JBossLocalModel.this);
                int serverPort = this.getServerPort();
                int shutdownPort = this.getShutdownPort();
                if (serverPort == Integer.MAX_VALUE) {
                    throw new RuntimeConfigurationError(JBossBundle.getText("JBossLocalModel.error.invalid", new Object[0]));
                }
                if (serverPort <= 0) {
                    throw new RuntimeConfigurationError(JBossBundle.getText("JBossLocalModel.error.disabled", new Object[0]));
                }
                if (shutdownPort == Integer.MAX_VALUE) {
                    throw new RuntimeConfigurationError(JBossBundle.getText("JBossLocalModel.error.shutdown.invalid", new Object[0]));
                }
                if (JBossLocalModel.this.isAuthRequired() && StringUtil.isEmpty((String)JBossLocalModel.this.USERNAME)) {
                    throw new RuntimeConfigurationError(JBossBundle.getText("JBossLocalModel.error.auth.required", new Object[0]));
                }
            }

            @Override
            public int getServerPort() {
                return JBossPortConfig.getDefault(JBossLocalModel.this);
            }

            @Override
            public int getLocalPort() {
                int result = JBossPortConfig.getHttp(JBossLocalModel.this);
                if (result == Integer.MAX_VALUE) {
                    result = JBossLocalModel.this.getDefaultPort();
                }
                return result;
            }

            @Override
            public int getShutdownPort() {
                return JBossPortConfig.getShutdown(JBossLocalModel.this);
            }
        });
        this.myContributionsProvider.add(JBossVersion7Handler.ID, new LocalModelContribution(){

            @Override
            public void checkConfiguration() throws RuntimeConfigurationException {
                int serverPort = this.getServerPort();
                if (serverPort == Integer.MAX_VALUE) {
                    if (JBossLocalModel.this.isAtLeast8()) {
                        throw new RuntimeConfigurationError(JBossBundle.getText("JBossLocalModel.error.http.management.invalid", new Object[0]));
                    }
                    throw new RuntimeConfigurationError(JBossBundle.getText("JBossLocalModel.error.native.management.invalid", new Object[0]));
                }
                if (JBossLocalModel.this.isDomain()) {
                    if (StringUtil.isEmpty((String)JBossLocalModel.this.getServerGroup())) {
                        throw new RuntimeConfigurationError(JBossBundle.getText("JBossServerModel.error.server.group", new Object[0]));
                    }
                    if (StringUtil.isEmpty((String)Jboss7DomainHostConfig.getDomainHost(JBossLocalModel.this))) {
                        throw new RuntimeConfigurationError(JBossBundle.getText("JBossLocalModel.error.cannot.acquire.domain.host", new Object[0]));
                    }
                    if (Jboss7DomainServersConfig.getDomainServers(JBossLocalModel.this).isEmpty()) {
                        Runnable quickfix = () -> {
                            final File domainHostFile = JBossVersion7Handler.getDomainHostFile(JBossLocalModel.this);
                            new JBossConfigProcessor("/ns:host/ns:servers/ns:server[@group='" + JBossLocalModel.this.getServerGroup() + "'][1]"){

                                protected Object process(XPath xpath, Document doc) throws JDOMException, IOException {
                                    Element server = (Element)xpath.selectSingleNode((Object)doc);
                                    if (server != null) {
                                        server.setAttribute("auto-start", "true");
                                    }
                                    JDOMUtil.writeDocument((Document)doc, (File)domainHostFile, (String)"\n");
                                    return null;
                                }
                            }.get(domainHostFile);
                        };
                        throw new RuntimeConfigurationError(JBossBundle.getText("JBossLocalModel.no.single.server.configured", JBossLocalModel.this.getServerGroup()), quickfix);
                    }
                }
                JBossLocalModel.this.checkProcessJdk();
            }

            @Override
            public int getServerPort() {
                if (JBossLocalModel.this.isAtLeast8()) {
                    return JBoss7PortConfig.getHttpManagement(JBossLocalModel.this);
                }
                return JBoss7PortConfig.getNativeManagement(JBossLocalModel.this);
            }

            @Override
            public int getLocalPort() {
                return JBoss7PortConfig.getHttp(JBossLocalModel.this);
            }

            @Override
            public int getShutdownPort() {
                return this.getServerPort();
            }
        });
        this.myContributionsProvider.addDefault(new LocalModelContribution(){

            @Override
            public void checkConfiguration() throws RuntimeConfigurationException {
            }

            @Override
            public int getServerPort() {
                return 0;
            }

            @Override
            public int getLocalPort() {
                return 8080;
            }

            @Override
            public int getShutdownPort() {
                return 0;
            }
        });
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        JBossLocalModel result = (JBossLocalModel)((Object)super.clone());
        result.initLocal();
        return result;
    }

    public SettingsEditor<CommonModel> getEditor() {
        return new JBossLocalEditor();
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        this.getContribution(this.myContributionsProvider).checkConfiguration();
        super.checkConfiguration();
    }

    public int getLocalPort() {
        return this.getContribution(this.myContributionsProvider).getLocalPort();
    }

    protected int getServerPort() {
        return this.getContribution(this.myContributionsProvider).getServerPort();
    }

    public int getShutdownPort() {
        return this.getContribution(this.myContributionsProvider).getShutdownPort();
    }

    @Nullable
    public String getCurrentBindingSetName() {
        String result = this.BINDING_SET_NAME;
        if (StringUtil.isEmpty((String)result)) {
            result = JBossBindingConfig.getCurrentBindingSetName(this);
        }
        return result;
    }

    private boolean isAuthRequired() {
        try {
            File base = new File(new File(this.getHome(), "server"), this.SERVER);
            File config = new File(base, "deploy/jmx-invoker-service.xml");
            Document doc = JDOMUtil.loadDocument((File)config);
            Element element = (Element)XPath.selectSingleNode((Object)doc, (String)"server/mbean[@code='org.jboss.jmx.connector.invoker.InvokerAdaptorService']/xmbean/operation[name/text()='invoke']/descriptors/interceptors/interceptor[@code='org.jboss.jmx.connector.invoker.AuthenticationInterceptor']");
            return element != null;
        }
        catch (JDOMException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Nullable
    protected String getLogFilePath(String home) {
        if (!StringUtil.isEmpty((String)home) && !StringUtil.isEmpty((String)this.SERVER)) {
            return new File(home, "server/" + this.SERVER + "/log/server.log").getAbsolutePath();
        }
        return null;
    }

    protected boolean isTruncateLogFile() {
        return "5.1".compareTo(this.getVersion()) > 0;
    }

    public File getServersDirectory() {
        return new File(this.getHome(), "server");
    }

    private static interface LocalModelContribution
    extends JBossVersionContribution {
        public void checkConfiguration() throws RuntimeConfigurationException;

        public int getServerPort();

        public int getLocalPort();

        public int getShutdownPort();
    }
}

