/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.editor.valueclass;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PropertyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JBossPropertyDescriptor {
    private final String name;
    @Nullable
    private final SmartPsiElementPointer<PsiMethod> getter;
    @Nullable
    private final SmartPsiElementPointer<PsiMethod> setter;

    JBossPropertyDescriptor(@NotNull String name, @NotNull PsiClass psi) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javaee/oss/jboss/editor/valueclass/JBossPropertyDescriptor", "<init>"));
        }
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/javaee/oss/jboss/editor/valueclass/JBossPropertyDescriptor", "<init>"));
        }
        this.name = name;
        this.getter = this.createPointer(PropertyUtil.findPropertyGetter((PsiClass)psi, (String)name, (boolean)false, (boolean)false));
        this.setter = this.createPointer(PropertyUtil.findPropertySetter((PsiClass)psi, (String)name, (boolean)false, (boolean)false));
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jboss/editor/valueclass/JBossPropertyDescriptor", "getName"));
        }
        return string;
    }

    @Nullable
    PsiMethod getGetter() {
        return JBossPropertyDescriptor.getPsiMethod(this.getter);
    }

    @Nullable
    PsiMethod getSetter() {
        return JBossPropertyDescriptor.getPsiMethod(this.setter);
    }

    @Nullable
    private SmartPsiElementPointer<PsiMethod> createPointer(@Nullable PsiMethod method) {
        if (method != null) {
            return SmartPointerManager.getInstance((Project)method.getProject()).createSmartPsiElementPointer((PsiElement)method);
        }
        return null;
    }

    @Nullable
    private static PsiMethod getPsiMethod(SmartPsiElementPointer<PsiMethod> pointer) {
        return pointer != null ? (PsiMethod)pointer.getElement() : null;
    }
}

