/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.editor.reference;

import com.intellij.javaee.model.xml.EjbLocalRef;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.model.xml.JndiEnvironmentRefsGroup;
import com.intellij.javaee.oss.editor.JavaeeSectionInfo;
import com.intellij.javaee.oss.editor.JavaeeSectionInfoEditable;
import com.intellij.javaee.oss.jboss.JBossBundle;
import com.intellij.javaee.oss.jboss.editor.reference.JBossReferenceSection;
import com.intellij.javaee.oss.jboss.editor.reference.JBossReferenceUtil;
import com.intellij.javaee.oss.jboss.model.JBossEjbLocalRef;
import com.intellij.javaee.oss.jboss.model.JBossReferenceHolder;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class JBossEjbLocalRefSection
extends JBossReferenceSection<EjbLocalRef> {
    private final JndiEnvironmentRefsGroup group;
    private final JBossReferenceHolder holder;

    JBossEjbLocalRefSection(JndiEnvironmentRefsGroup group, JBossReferenceHolder holder) {
        this.group = group;
        this.holder = holder;
    }

    public List<EjbLocalRef> getValues() {
        return this.group == null ? Collections.emptyList() : this.group.getEjbLocalRefs();
    }

    @Override
    JavaeeSectionInfo<EjbLocalRef> createFirstColumn() {
        return new JavaeeSectionInfo<EjbLocalRef>(JBossBundle.getText("JBossReferenceEditor.ejb.local", new Object[0])){

            public String valueOf(EjbLocalRef source) {
                return (String)source.getEjbRefName().getValue();
            }
        };
    }

    @Override
    JavaeeSectionInfo<EjbLocalRef> createSecondColumn() {
        return new JavaeeSectionInfoEditable<EjbLocalRef>(JBossBundle.getText("JBossReferenceEditor.jndi.name", new Object[0]), (JavaeeDomModelElement)this.holder){

            @Nullable
            public String valueOf(EjbLocalRef source) {
                JBossEjbLocalRef target = JBossReferenceUtil.findEjbLocalRef(JBossEjbLocalRefSection.this.holder, source);
                return target == null ? null : (String)target.getLocalJndiName().getValue();
            }

            protected void write(EjbLocalRef item, String value) {
                JBossEjbLocalRef target = JBossReferenceUtil.findEjbLocalRef(JBossEjbLocalRefSection.this.holder, item);
                if (!StringUtil.isEmpty((String)value)) {
                    if (target == null) {
                        target = JBossEjbLocalRefSection.this.holder.addEjbLocalRef();
                        target.getEjbRefName().setValue((Object)item);
                    }
                    target.getLocalJndiName().setValue((Object)value);
                } else if (target != null) {
                    target.undefine();
                }
            }
        };
    }
}

