/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.config;

import com.intellij.javaee.oss.jboss.config.JBossBindingSet;
import com.intellij.javaee.oss.jboss.config.JBossConfigFileProvider;
import com.intellij.javaee.oss.jboss.config.JBossPortConfig;
import com.intellij.javaee.oss.jboss.config.JBossPortHandler;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.oss.util.ConfigFileWrapper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class JBossBindingProvider {
    private final File myFile;
    private final String myBeanName;

    public JBossBindingProvider(JBossConfigFileProvider fileProvider, String configFilePath, String beanName) {
        this.myFile = fileProvider.getConfigFile(configFilePath);
        this.myBeanName = beanName;
    }

    public File getFile() {
        return this.myFile;
    }

    @Nullable
    public Integer getPort(final JBossPortHandler portHandler, final JavaeeServerModel model) {
        return (Integer)new ConfigFileWrapper<Integer>(){

            protected Integer doGet(Element rootElement) {
                Element bean = 1.getChild((Element)rootElement, (String)"bean", (String)"name", (String)"StandardBindings");
                if (bean == null) {
                    return null;
                }
                Element set = 1.getChild((Element)1.getChild((Element)1.getChild((Element)bean, (String)"constructor"), (String)"parameter"), (String)"set");
                for (Element child : 1.getChildren((Element)set, (String)"bean")) {
                    Element port;
                    Element binding;
                    Element service = 1.getChild((Element)child, (String)"property", (String)"name", (String)"serviceName");
                    if (service == null || !portHandler.getServiceName().equals(service.getTextTrim()) || portHandler.checkBindingName() && ((binding = 1.getChild((Element)child, (String)"property", (String)"name", (String)"bindingName")) == null || !"port".equalsIgnoreCase(binding.getTextTrim())) || (port = 1.getChild((Element)child, (String)"property", (String)"name", (String)"port")) == null) continue;
                    return JBossPortConfig.parsePort(port.getTextTrim(), model);
                }
                return null;
            }
        }.get(this.myFile);
    }

    @Nullable
    public String getCurrentBindingSetName() {
        return (String)new ConfigFileWrapper<String>(){

            protected String doGet(Element rootElement) {
                Element bean = 2.getChild((Element)rootElement, (String)"bean", (String)"name", (String)JBossBindingProvider.this.myBeanName);
                if (bean != null) {
                    String text = 2.getChild((Element)2.getChild((Element)bean, (String)"constructor"), (String)"parameter").getTextTrim();
                    Matcher matcher = Pattern.compile("\\$\\{jboss\\.service\\.binding\\.set:(.+)\\}").matcher(text);
                    if (matcher.matches()) {
                        return matcher.group(1);
                    }
                }
                return null;
            }
        }.get(this.myFile);
    }

    @Nullable
    public List<JBossBindingSet> getBindingSets() {
        final ArrayList<JBossBindingSet> result = new ArrayList<JBossBindingSet>();
        new ConfigFileWrapper(){

            protected Object doGet(Element rootElement) {
                for (Element child : 3.getChildren((Element)rootElement, (String)"bean", (String)"class", (String)".*\\.ServiceBindingSet")) {
                    List parameters = 3.getChildren((Element)3.getChild((Element)child, (String)"constructor"), (String)"parameter");
                    if (parameters.size() != 4) continue;
                    result.add(new JBossBindingSet(((Element)parameters.get(0)).getTextTrim(), Integer.valueOf(((Element)parameters.get(2)).getTextTrim())));
                }
                return null;
            }
        }.get(this.myFile);
        return result.isEmpty() ? null : result;
    }
}

