/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.config;

import com.intellij.javaee.oss.jboss.config.JBossBindingGetter;
import com.intellij.javaee.oss.jboss.config.JBossBindingProvider;
import com.intellij.javaee.oss.jboss.config.JBossBindingProviderSet;
import com.intellij.javaee.oss.jboss.config.JBossBindingSet;
import com.intellij.javaee.oss.jboss.config.JBossConfigFileProvider;
import com.intellij.javaee.oss.jboss.server.JBossLocalModel;
import com.intellij.javaee.oss.util.CachedConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBossBindingConfig
extends CachedConfig<JBossLocalModel> {
    private static final Map<CachedConfig.Key, JBossBindingConfig> ourCache = new HashMap<CachedConfig.Key, JBossBindingConfig>();
    private static final CachedConfig.Factory<JBossLocalModel, JBossBindingConfig> ourFactory = new CachedConfig.Factory<JBossLocalModel, JBossBindingConfig>(){

        @NotNull
        public CachedConfig.Key createKey(JBossLocalModel data) {
            CachedConfig.Key key = new CachedConfig.Key(new String[]{data.getHome(), data.SERVER});
            if (key == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jboss/config/JBossBindingConfig$1", "createKey"));
            }
            return key;
        }

        @NotNull
        public JBossBindingConfig createConfig(JBossLocalModel data) {
            JBossBindingConfig jBossBindingConfig = new JBossBindingConfig(data.getHome(), data.SERVER);
            if (jBossBindingConfig == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jboss/config/JBossBindingConfig$1", "createConfig"));
            }
            return jBossBindingConfig;
        }
    };
    private final JBossBindingProviderSet myProviderSet;
    private String myCurrentBindingSetName;
    private List<JBossBindingSet> myBindingSets;

    private JBossBindingConfig(String home, String server) {
        JBossConfigFileProvider fileProvider = new JBossConfigFileProvider(home, server);
        this.myProviderSet = new JBossBindingProviderSet(fileProvider);
    }

    @Nullable
    private static JBossBindingConfig getInstance(JBossLocalModel model) {
        return (JBossBindingConfig)JBossBindingConfig.get(ourCache, ourFactory, (Object)((Object)model));
    }

    @Nullable
    public static List<JBossBindingSet> getBindingSets(JBossLocalModel model) {
        JBossBindingConfig instance = JBossBindingConfig.getInstance(model);
        return instance == null ? null : instance.myBindingSets;
    }

    @Nullable
    public static String getCurrentBindingSetName(JBossLocalModel model) {
        JBossBindingConfig instance = JBossBindingConfig.getInstance(model);
        return instance == null ? null : instance.myCurrentBindingSetName;
    }

    protected long getStamp(JBossLocalModel data) {
        return this.myProviderSet.getStamp();
    }

    protected void update(JBossLocalModel data) {
        this.myCurrentBindingSetName = this.myProviderSet.get(new JBossBindingGetter<String>(){

            @Override
            public String get(JBossBindingProvider provider) {
                return provider.getCurrentBindingSetName();
            }
        });
        this.myBindingSets = this.myProviderSet.get(new JBossBindingGetter<List<JBossBindingSet>>(){

            @Override
            public List<JBossBindingSet> get(JBossBindingProvider provider) {
                return provider.getBindingSets();
            }
        });
    }
}

