/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.aop.AopProvider;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.aop.SpringAdvisedElementsSearcher;
import com.intellij.spring.aop.SpringAopBundle;
import com.intellij.spring.aop.SpringAopProvider;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.highlighting.EnableAspectJQuickFix;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MissingAspectjAutoproxyInspection
extends LocalInspectionTool {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/model/highlighting/MissingAspectjAutoproxyInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/highlighting/MissingAspectjAutoproxyInspection", "checkFile"));
        }
        if (JamCommonUtil.isPlainJavaFile((PsiElement)file)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
            if (SpringLibraryUtil.isAtLeastVersion((Module)module, (SpringLibraryUtil.SpringVersion)SpringLibraryUtil.SpringVersion.V_2_5)) {
                return null;
            }
            for (PsiClass aClass : ((PsiJavaFile)file).getClasses()) {
                LocalQuickFix[] localQuickFixArray;
                SpringAopProvider provider;
                AopAdvisedElementsSearcher searcher;
                PsiJavaCodeReferenceElement annoName;
                PsiModifierList modifierList = aClass.getModifierList();
                if (modifierList == null) continue;
                PsiAnnotation annotation = modifierList.findAnnotation("org.aspectj.lang.annotation.Aspect");
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = annoName = annotation == null ? null : annotation.getNameReferenceElement();
                if (annoName == null || !((searcher = (provider = (SpringAopProvider)((Object)Extensions.findExtension((ExtensionPointName)AopProvider.EXTENSION_POINT_NAME, SpringAopProvider.class))).getAdvisedElementsSearcher(aClass)) instanceof SpringAdvisedElementsSearcher)) continue;
                CommonSpringModel model = ((SpringAdvisedElementsSearcher)searcher).getSpringModel();
                PsiClass aspectJAutoProxy = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.aop.aspectj.annotation.AnnotationAwareAspectJAutoProxyCreator");
                if (aspectJAutoProxy != null && MissingAspectjAutoproxyInspection.isAspectJSupportEnabled(model, aspectJAutoProxy)) continue;
                List<XmlSpringModel> models = SpringAdvisedElementsSearcher.findXmlModels(model);
                if (models.isEmpty()) {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                } else {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = new EnableAspectJQuickFix((CommonSpringModel)models.iterator().next());
                }
                LocalQuickFix[] fixes = localQuickFixArray;
                return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)annoName, SpringAopBundle.message("aop.warning.aspectj.isnt.enabled", new Object[0]), isOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
            }
        }
        return super.checkFile(file, manager, isOnTheFly);
    }

    @NotNull
    public String getShortName() {
        if ("MissingAspectjAutoproxyInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/MissingAspectjAutoproxyInspection", "getShortName"));
        }
        return "MissingAspectjAutoproxyInspection";
    }

    public static boolean isAspectJSupportEnabled(CommonSpringModel model, @NotNull PsiClass aspectJBeanClass) {
        if (aspectJBeanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aspectJBeanClass", "com/intellij/spring/model/highlighting/MissingAspectjAutoproxyInspection", "isAspectJSupportEnabled"));
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)aspectJBeanClass);
        for (XmlSpringModel xmlModel : SpringAdvisedElementsSearcher.findXmlModels(model)) {
            if (!SpringModelSearchers.doesBeanExist((CommonSpringModel)xmlModel, (SpringModelSearchParameters.BeanClass)searchParameters)) continue;
            return true;
        }
        return false;
    }
}

