/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.settings;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSLanguage;

public class LESSLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        LESSLanguage lESSLanguage = LESSLanguage.INSTANCE;
        if (lESSLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/settings/LESSLanguageCodeStyleSettingsProvider", "getLanguage"));
        }
        return lESSLanguage;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "org/jetbrains/plugins/less/settings/LESSLanguageCodeStyleSettingsProvider", "getCodeSample"));
        }
        return "@base: #f938ab;\n\n.box-shadow(@style, @c) when (iscolor(@c)) {\n  box-shadow:         @style @c;\n  -webkit-box-shadow: @style @c;\n  -moz-box-shadow:    @style @c;\n}\n.box-shadow(@style, @alpha: 50%) when (isnumber(@alpha)) {\n  .box-shadow(@style, rgba(0, 0, 0, @alpha));\n}\n.box { \n  color: saturate(@base, 5%);\n  border-color: lighten(@base, 30%);\n  div { .box-shadow(0 0 5px, 30%) }\n}";
    }

    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings defaultSettings = new CommonCodeStyleSettings((Language)LESSLanguage.INSTANCE);
        defaultSettings.LINE_COMMENT_AT_FIRST_COLUMN = false;
        defaultSettings.BLOCK_COMMENT_AT_FIRST_COLUMN = false;
        CommonCodeStyleSettings.IndentOptions indentOptions = defaultSettings.initIndentOptions();
        indentOptions.INDENT_SIZE = 2;
        return defaultSettings;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }
}

