/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.references;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.resolve.StylesheetFileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.psi.LESSFile;
import org.jetbrains.plugins.less.psi.impl.LessImportType;

public class LessImportReference
extends StylesheetFileReference {
    @NonNls
    private static final String LESS_EXT = ".less";
    @NonNls
    private static final String CSS_EXT = ".css";
    private final boolean mySoft;
    private final boolean myDefinesExtension;

    public LessImportReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text) {
        if (fileReferenceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "org/jetbrains/plugins/less/references/LessImportReference", "<init>"));
        }
        super(fileReferenceSet, range, index, text);
        Set<String> importTypes = LessImportReference.getImportTypes(this.getElement());
        this.mySoft = importTypes.contains("optional");
        this.myDefinesExtension = importTypes.contains("css") || importTypes.contains("less");
    }

    @NotNull
    public String getFileNameToCreate() {
        String result = super.getFileNameToCreate();
        if (!this.isLast()) {
            String string = result;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/references/LessImportReference", "getFileNameToCreate"));
            }
            return string;
        }
        String string = result.endsWith(LESS_EXT) || result.endsWith(CSS_EXT) || this.myDefinesExtension ? result : result + LESS_EXT;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/references/LessImportReference", "getFileNameToCreate"));
        }
        return string;
    }

    protected Object createLookupItem(PsiElement candidate) {
        if (candidate instanceof LESSFile) {
            PsiFile psiFile = (PsiFile)candidate;
            LookupElementBuilder fileLookupItem = FileInfoManager.getFileLookupItem((PsiElement)psiFile, (String)this.createImportTextForFileName(null, psiFile.getName()), (Icon)psiFile.getIcon(0));
            return fileLookupItem.withTypeText(psiFile.getName(), true);
        }
        return super.createLookupItem(candidate);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return super.handleElementRename(this.createImportTextForFileName(this.getCanonicalText(), newElementName));
    }

    protected PsiElement rename(String newName) throws IncorrectOperationException {
        return super.rename(this.createImportTextForFileName(this.getCanonicalText(), newName));
    }

    @NotNull
    protected ResolveResult[] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        int resultCount;
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/plugins/less/references/LessImportReference", "innerResolve"));
        }
        String referenceText = StringUtil.unquoteString((String)this.getText());
        HashSet result = Sets.newHashSet((Object[])super.innerResolve(caseSensitive, containingFile));
        if (this.isLast() && !referenceText.isEmpty()) {
            result.addAll(this.innerResolveWithNameVariants(caseSensitive, referenceText));
        }
        ResolveResult[] resolveResultArray = (resultCount = result.size()) > 0 ? result.toArray(new ResolveResult[resultCount]) : ResolveResult.EMPTY_ARRAY;
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/references/LessImportReference", "innerResolve"));
        }
        return resolveResultArray;
    }

    private Collection<ResolveResult> innerResolveWithNameVariants(boolean caseSensitive, String referenceText) {
        Collection<ResolveResult> result = this.innerResolve(caseSensitive, referenceText);
        if (!(referenceText.endsWith(LESS_EXT) || referenceText.endsWith(CSS_EXT) || this.myDefinesExtension)) {
            result.addAll(this.innerResolve(caseSensitive, referenceText + LESS_EXT));
        }
        return result;
    }

    private Collection<ResolveResult> innerResolve(boolean caseSensitive, String referenceText) {
        Collection contexts = this.getContexts();
        THashSet result = new THashSet();
        for (PsiFileSystemItem context : contexts) {
            if (context == null) continue;
            this.innerResolveInContext(referenceText, context, (Collection)result, caseSensitive);
        }
        return result;
    }

    private String createImportTextForFileName(String oldText, String fileName) {
        if (oldText != null && oldText.endsWith(LESS_EXT)) {
            return fileName;
        }
        return fileName.endsWith(LESS_EXT) && !this.myDefinesExtension ? LessImportReference.withoutExtension(fileName) : fileName;
    }

    private static String withoutExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        return index < 0 ? fileName : fileName.substring(0, index);
    }

    public boolean isSoft() {
        return this.mySoft;
    }

    @NotNull
    public static Set<String> getImportTypes(@Nullable PsiElement element) {
        CssImport importElement = (CssImport)PsiTreeUtil.getParentOfType((PsiElement)element, CssImport.class);
        LessImportType importType = (LessImportType)PsiTreeUtil.getChildOfType((PsiElement)importElement, LessImportType.class);
        Set<String> set = importType != null ? importType.getImportTypes() : Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/references/LessImportReference", "getImportTypes"));
        }
        return set;
    }
}

