/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.references;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.util.CssReferenceProvider;
import com.intellij.psi.css.resolve.CssReferenceProviderUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSFileType;
import org.jetbrains.plugins.less.LESSLanguage;
import org.jetbrains.plugins.less.references.LessImportReferenceSet;

public class LESSReferenceContributor
extends PsiReferenceContributor {
    private static final String DATA_URI_FUNCTION_NAME = "data-uri";

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/plugins/less/references/LESSReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement().with((PatternCondition)new LessReferencePattern()), (PsiReferenceProvider)new LESSReferenceProvider(), 100.0);
    }

    @NotNull
    public static PsiReference[] findReferencesForDataUriArgument(@NotNull PsiElement element) {
        CssTerm[] terms;
        PsiElement function;
        PsiElement termList;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/less/references/LESSReferenceContributor", "findReferencesForDataUriArgument"));
        }
        PsiElement parent = element.getParent();
        if (parent instanceof CssTerm && (termList = parent.getParent()) instanceof CssTermList && (function = termList.getParent()) instanceof CssFunction && DATA_URI_FUNCTION_NAME.equalsIgnoreCase(((CssFunction)function).getName()) && ((terms = ((CssTermList)termList).getTerms()).length == 1 || terms.length == 2 && terms[1] == parent)) {
            PsiReference[] psiReferenceArray = CssReferenceProviderUtil.getFileReferences((PsiElement)element, (boolean)false, (boolean)true, (FileType[])CssReferenceProvider.IMAGE_FILE_TYPES);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/references/LESSReferenceContributor", "findReferencesForDataUriArgument"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/references/LESSReferenceContributor", "findReferencesForDataUriArgument"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static class LessReferencePattern
    extends PatternCondition<PsiElement> {
        public LessReferencePattern() {
            super("less import reference");
        }

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/less/references/LESSReferenceContributor$LessReferencePattern", "accepts"));
            }
            return CssPsiUtil.getStylesheetLanguage((PsiElement)element) == LESSLanguage.INSTANCE && CssReferenceProvider.isStringOrUrl((PsiElement)element);
        }
    }

    private static class LESSReferenceProvider
    extends PsiReferenceProvider {
        private LESSReferenceProvider() {
        }

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/less/references/LESSReferenceContributor$LESSReferenceProvider", "getReferencesByElement"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/less/references/LESSReferenceContributor$LESSReferenceProvider", "getReferencesByElement"));
            }
            PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getCachedValue((PsiElement)element, () -> {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/less/references/LESSReferenceContributor$LESSReferenceProvider", "lambda$getReferencesByElement$0"));
                }
                return CachedValueProvider.Result.create((Object)LESSReferenceProvider.getReferences(element), (Object[])new Object[]{element});
            });
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/references/LESSReferenceContributor$LESSReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }

        @NotNull
        private static PsiReference[] getReferences(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/less/references/LESSReferenceContributor$LESSReferenceProvider", "getReferences"));
            }
            if (CssReferenceProvider.isStringOrUrl((PsiElement)element)) {
                PsiReference[] referencesForDataUriArgument = LESSReferenceContributor.findReferencesForDataUriArgument(element);
                if (referencesForDataUriArgument.length > 0) {
                    if (referencesForDataUriArgument == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/references/LESSReferenceContributor$LESSReferenceProvider", "getReferences"));
                    }
                    return referencesForDataUriArgument;
                }
                if (CssReferenceProvider.isInImport((PsiElement)element)) {
                    PsiReference[] psiReferenceArray = LESSReferenceProvider.getImportReferences(element);
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/references/LESSReferenceContributor$LESSReferenceProvider", "getReferences"));
                    }
                    return psiReferenceArray;
                }
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/references/LESSReferenceContributor$LESSReferenceProvider", "getReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }

        private static PsiReference[] getImportReferences(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/less/references/LESSReferenceContributor$LESSReferenceProvider", "getImportReferences"));
            }
            Pair referenceData = CssReferenceProviderUtil.getFileReferenceData((PsiElement)element);
            if (referenceData != null && !HtmlUtil.hasHtmlPrefix((String)((String)referenceData.first))) {
                LessImportReferenceSet referenceSet = new LessImportReferenceSet(element, (String)referenceData.first, (TextRange)referenceData.second, new FileType[]{LESSFileType.LESS, CssFileType.INSTANCE});
                return referenceSet.getAllReferences();
            }
            return PsiReference.EMPTY_ARRAY;
        }
    }
}

