/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.LESSElementTypes;
import org.jetbrains.plugins.less.psi.LessElement;
import org.jetbrains.plugins.less.psi.impl.LESSElementVisitor;
import org.jetbrains.plugins.less.psi.impl.LESSVariableImpl;

public class LessNamedArgument
extends CompositePsiElement
implements LessElement {
    protected LessNamedArgument() {
        super(LESSElementTypes.LESS_NAMED_ARGUMENT);
    }

    @Nullable
    public LESSVariableImpl getVariableElement() {
        return (LESSVariableImpl)this.findPsiChildByType(LESSElementTypes.LESS_VARIABLE);
    }

    @NotNull
    public String getName() {
        LESSVariableImpl namedElement = this.getVariableElement();
        String string = namedElement != null ? namedElement.getName() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/psi/impl/LessNamedArgument", "getName"));
        }
        return string;
    }

    public int getTextOffset() {
        LESSVariableImpl element = this.getVariableElement();
        return element != null ? element.getTextOffset() : super.getTextOffset();
    }

    @Nullable
    public PsiElement getValue() {
        return this.getLastChild();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/less/psi/impl/LessNamedArgument", "setName"));
        }
        LESSVariableImpl namedElement = this.getVariableElement();
        if (namedElement != null) {
            namedElement.setName(name);
        }
        return this;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/plugins/less/psi/impl/LessNamedArgument", "accept"));
        }
        if (visitor instanceof LESSElementVisitor) {
            ((LESSElementVisitor)visitor).visitLessNamedArgument(this);
            return;
        }
        super.accept(visitor);
    }

    public Icon getIcon(int flags) {
        return AllIcons.Nodes.Parameter;
    }
}

