/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.psi.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSElementTypes;
import org.jetbrains.plugins.less.psi.LESSElementGenerator;
import org.jetbrains.plugins.less.psi.LessElement;
import org.jetbrains.plugins.less.psi.impl.LESSElementVisitor;
import org.jetbrains.plugins.less.psi.impl.LessNamedArgument;
import org.jetbrains.plugins.less.psi.impl.LessVariableInterpolationImpl;
import org.jetbrains.plugins.less.references.LESSVariableReference;
import org.jetbrains.plugins.less.references.LessNamedArgumentReference;

public class LESSVariableImpl
extends CompositePsiElement
implements LessElement,
PsiNamedElement {
    protected LESSVariableImpl() {
        super(LESSElementTypes.LESS_VARIABLE);
    }

    public PsiReference getReference() {
        return this.getParent() instanceof LessNamedArgument ? new LessNamedArgumentReference(this) : new LESSVariableReference(this);
    }

    public PsiElement setName(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "org/jetbrains/plugins/less/psi/impl/LESSVariableImpl", "setName"));
        }
        LESSVariableImpl variable = this.getParent() instanceof LessVariableInterpolationImpl ? LESSElementGenerator.createVariableInInterpolation(this.getProject(), newName) : LESSElementGenerator.createVariable(this.getProject(), LESSVariableImpl.createNewName(newName));
        return variable != null ? this.replace((PsiElement)variable) : this;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/plugins/less/psi/impl/LESSVariableImpl", "accept"));
        }
        if (visitor instanceof LESSElementVisitor) {
            ((LESSElementVisitor)visitor).visitLESSVariable(this);
            return;
        }
        super.accept(visitor);
    }

    public int getTextOffset() {
        int textOffset = super.getTextOffset();
        return StringUtil.startsWithChar((CharSequence)this.getText(), (char)'@') ? textOffset + 1 : textOffset;
    }

    @NotNull
    public String getName() {
        String text = this.getText();
        String string = StringUtil.startsWithChar((CharSequence)text, (char)'@') ? text.substring(1) : text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/psi/impl/LESSVariableImpl", "getName"));
        }
        return string;
    }

    private static String createNewName(String name) {
        return StringUtil.startsWithChar((CharSequence)name, (char)'@') ? name : "@" + name;
    }
}

