/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.psi.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.LESSElementTypes;
import org.jetbrains.plugins.less.psi.LESSElementGenerator;
import org.jetbrains.plugins.less.psi.impl.LESSElementVisitor;
import org.jetbrains.plugins.less.psi.impl.LESSMixinName;
import org.jetbrains.plugins.less.references.LESSNamespaceReference;

public class LESSNamespace
extends LESSMixinName
implements PsiNameIdentifierOwner {
    public static final ArrayFactory<LESSNamespace> ARRAY_FACTORY = LESSNamespace[]::new;
    public static final Joiner NAMESPACE_JOINER = Joiner.on((char)'>');

    protected LESSNamespace() {
        super(LESSElementTypes.LESS_NAMESPACE);
    }

    @NotNull
    public String getNamespace() {
        ArrayList namespaces = Lists.newArrayList();
        for (LESSNamespace parentNamespace = this.getParentNamespace(); parentNamespace != null; parentNamespace = parentNamespace.getParentNamespace()) {
            namespaces.add(parentNamespace.getFullName());
        }
        String string = NAMESPACE_JOINER.join((Iterable)ContainerUtil.reverse((List)namespaces));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/psi/impl/LESSNamespace", "getNamespace"));
        }
        return string;
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/less/psi/impl/LESSNamespace", "setName"));
        }
        LESSNamespace newElement = LESSElementGenerator.createNamespace(this.getProject(), this.createNewName(name));
        if (newElement != null) {
            return this.replace((PsiElement)newElement);
        }
        return this;
    }

    public PsiReference getReference() {
        return new LESSNamespaceReference(this);
    }

    @Nullable
    private LESSNamespace getParentNamespace() {
        return (LESSNamespace)PsiTreeUtil.getPrevSiblingOfType((PsiElement)this, LESSNamespace.class);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.getNamedElement();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/plugins/less/psi/impl/LESSNamespace", "accept"));
        }
        if (visitor instanceof LESSElementVisitor) {
            ((LESSElementVisitor)visitor).visitLESSNamespace(this);
            return;
        }
        super.accept(visitor);
    }
}

