/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.impl.CssNamedItemPresentation;
import com.intellij.psi.css.impl.stubs.base.CssNamedStub;
import com.intellij.psi.css.impl.stubs.base.CssNamedStubElement;
import com.intellij.psi.css.impl.stubs.base.CssNamedStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import icons.LessIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.psi.LessParameter;
import org.jetbrains.plugins.less.psi.LessRuleset;
import org.jetbrains.plugins.less.psi.impl.LESSElementVisitor;
import org.jetbrains.plugins.less.psi.impl.LESSNamespace;
import org.jetbrains.plugins.less.psi.impl.LESSPrimitiveMixin;
import org.jetbrains.plugins.less.psi.impl.LessParameterList;
import org.jetbrains.plugins.less.psi.stubs.impl.LessMixinStub;

public abstract class LESSMixin
extends CssNamedStubElement<LessMixinStub>
implements LessRuleset,
NavigatablePsiElement,
PsiNameIdentifierOwner {
    public LESSMixin(@NotNull LessMixinStub stub, @NotNull CssNamedStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/plugins/less/psi/LESSMixin", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "org/jetbrains/plugins/less/psi/LESSMixin", "<init>"));
        }
        super((CssNamedStub)stub, nodeType);
    }

    public LESSMixin(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/less/psi/LESSMixin", "<init>"));
        }
        super(node);
    }

    @NotNull
    public String getNamespace() {
        ArrayList namespaces = Lists.newArrayList();
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)this, (Class[])new Class[]{PsiFile.class, CssRuleset.class, LESSMixin.class});
        while (parent != null) {
            PsiElement grandParent = parent.getParent();
            if (parent instanceof CssRuleset && grandParent instanceof LESSPrimitiveMixin) {
                parent = grandParent;
            }
            if (parent instanceof LESSMixin && !((LESSMixin)parent).hasParameters()) {
                namespaces.add(((LESSMixin)parent).getFullName());
            }
            parent = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{CssRuleset.class, LESSMixin.class, PsiFile.class});
        }
        String string = LESSNamespace.NAMESPACE_JOINER.join((Iterable)Lists.reverse((List)namespaces));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/psi/LESSMixin", "getNamespace"));
        }
        return string;
    }

    @Nullable
    public String getNamespaceInContext(@Nullable PsiElement context) {
        ArrayList namespaces = Lists.newArrayList();
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)this, (Class[])new Class[]{PsiFile.class, CssRuleset.class, LESSMixin.class});
        while (parent != null && (context == null || PsiTreeUtil.isAncestor((PsiElement)context, (PsiElement)parent, (boolean)true))) {
            PsiElement grandParent = parent.getParent();
            if (parent instanceof CssRuleset && grandParent instanceof LESSPrimitiveMixin) {
                parent = grandParent;
            }
            if (parent instanceof LESSMixin && !((LESSMixin)parent).hasParameters()) {
                namespaces.add(((LESSMixin)parent).getFullName());
                parent = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{CssRuleset.class, LESSMixin.class, PsiFile.class});
                continue;
            }
            return null;
        }
        return LESSNamespace.NAMESPACE_JOINER.join((Iterable)Lists.reverse((List)namespaces));
    }

    public int getTextOffset() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        return nameIdentifier != null ? nameIdentifier.getTextOffset() : super.getTextOffset();
    }

    @NotNull
    public abstract String getName();

    public String getFullName() {
        LessMixinStub stub = (LessMixinStub)this.getStub();
        if (stub != null) {
            return stub.getFullName();
        }
        PsiElement fullNameIdentifier = this.getFullNameIdentifier();
        return fullNameIdentifier != null ? fullNameIdentifier.getText() : "";
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/less/psi/LESSMixin", "setName"));
        }
        PsiElement identifier = this.getFullNameIdentifier();
        if (identifier instanceof PsiNamedElement) {
            ((PsiNamedElement)identifier).setName(name);
        }
        return this;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        CssNamedItemPresentation cssNamedItemPresentation = new CssNamedItemPresentation((PsiNamedElement)this, this.getFullName() + this.getParametersString());
        if (cssNamedItemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/psi/LESSMixin", "getPresentation"));
        }
        return cssNamedItemPresentation;
    }

    public boolean hasParameters() {
        return this.getParameters().length > 0;
    }

    @NotNull
    public LessParameter[] getParameters() {
        LessParameterList parameterList = this.getParameterListElement();
        LessParameter[] lessParameterArray = parameterList != null ? parameterList.getParameters() : LessParameter.EMPTY_ARRAY;
        if (lessParameterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/psi/LESSMixin", "getParameters"));
        }
        return lessParameterArray;
    }

    @NotNull
    public String getParametersString() {
        LessParameterList parameterList = this.getParameterListElement();
        String string = parameterList != null ? "(" + parameterList.getPresentableString() + ")" : "()";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/psi/LESSMixin", "getParametersString"));
        }
        return string;
    }

    public Icon getIcon(int flags) {
        return LessIcons.Mixin;
    }

    @Nullable
    public abstract LessParameterList getParameterListElement();

    @Nullable
    public abstract PsiElement getFullNameIdentifier();

    @NotNull
    public PsiElement getTargetForReference() {
        LESSMixin lESSMixin = this;
        if (lESSMixin == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/psi/LESSMixin", "getTargetForReference"));
        }
        return lESSMixin;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/plugins/less/psi/LESSMixin", "accept"));
        }
        if (visitor instanceof LESSElementVisitor) {
            ((LESSElementVisitor)visitor).visitMixin(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

