/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.inspections.suppress;

import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssOneLineStatement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.inspections.suppress.LessSuppressAllForAtRuleCommentFix;
import org.jetbrains.plugins.less.inspections.suppress.LessSuppressAllForMixinCommentFix;
import org.jetbrains.plugins.less.inspections.suppress.LessSuppressAllForRulesetCommentFix;
import org.jetbrains.plugins.less.inspections.suppress.LessSuppressForAtRuleCommentFix;
import org.jetbrains.plugins.less.inspections.suppress.LessSuppressForMixinCommentFix;
import org.jetbrains.plugins.less.inspections.suppress.LessSuppressForRulesetCommentFix;
import org.jetbrains.plugins.less.inspections.suppress.LessSuppressForStatementCommentFix;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.LessParameter;
import org.jetbrains.plugins.less.psi.LessRuleset;
import org.jetbrains.plugins.less.psi.LessStatement;

public class LessSuppressionUtil {
    public static boolean isSuppressedFor(final @Nullable PsiElement element, final @NotNull String toolId) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "org/jetbrains/plugins/less/inspections/suppress/LessSuppressionUtil", "isSuppressedFor"));
        }
        if (element == null) {
            return true;
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (LessSuppressionUtil.getSuppressedInCssStatement(element, toolId) != null) {
                    return true;
                }
                if (LessSuppressionUtil.getSuppressedInLessStatement(element, toolId) != null) {
                    return true;
                }
                if (LessSuppressionUtil.getSuppressedInCssRuleset(element, toolId) != null) {
                    return true;
                }
                if (LessSuppressionUtil.getSuppressedInLessRuleset(element, toolId) != null) {
                    return true;
                }
                if (LessSuppressionUtil.getSuppressedInBlockAtRule(element, toolId) != null) {
                    return true;
                }
                return false;
            }
        });
    }

    @Nullable
    public static PsiElement getSuppressibleStatement(@Nullable PsiElement context) {
        PsiElement statement = PsiTreeUtil.getTopmostParentOfType((PsiElement)context, CssOneLineStatement.class);
        if (statement != null && statement.getParent() instanceof LessParameter) {
            return null;
        }
        return statement;
    }

    @Nullable
    public static PsiElement getSuppressibleCssRuleset(@Nullable PsiElement context) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssRuleset.class});
    }

    @Nullable
    public static PsiElement getSuppressibleMixin(@Nullable PsiElement context) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{LESSMixin.class});
    }

    @Nullable
    public static PsiElement getSuppressibleAtRule(@Nullable PsiElement context) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssAtRule.class});
    }

    @Nullable
    private static PsiElement getSuppressedInLessStatement(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/less/inspections/suppress/LessSuppressionUtil", "getSuppressedInLessStatement"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "org/jetbrains/plugins/less/inspections/suppress/LessSuppressionUtil", "getSuppressedInLessStatement"));
        }
        return LessSuppressionUtil.getStatementToolSuppressedIn(element, toolId, LessStatement.class);
    }

    @Nullable
    private static PsiElement getSuppressedInCssStatement(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/less/inspections/suppress/LessSuppressionUtil", "getSuppressedInCssStatement"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "org/jetbrains/plugins/less/inspections/suppress/LessSuppressionUtil", "getSuppressedInCssStatement"));
        }
        return LessSuppressionUtil.getStatementToolSuppressedIn(element, toolId, CssOneLineStatement.class);
    }

    @Nullable
    private static PsiElement getSuppressedInLessRuleset(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/less/inspections/suppress/LessSuppressionUtil", "getSuppressedInLessRuleset"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "org/jetbrains/plugins/less/inspections/suppress/LessSuppressionUtil", "getSuppressedInLessRuleset"));
        }
        return LessSuppressionUtil.getStatementToolSuppressedIn(element, toolId, LessRuleset.class);
    }

    @Nullable
    private static PsiElement getSuppressedInCssRuleset(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/less/inspections/suppress/LessSuppressionUtil", "getSuppressedInCssRuleset"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "org/jetbrains/plugins/less/inspections/suppress/LessSuppressionUtil", "getSuppressedInCssRuleset"));
        }
        return LessSuppressionUtil.getStatementToolSuppressedIn(element, toolId, CssRuleset.class);
    }

    @Nullable
    private static PsiElement getSuppressedInBlockAtRule(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/less/inspections/suppress/LessSuppressionUtil", "getSuppressedInBlockAtRule"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "org/jetbrains/plugins/less/inspections/suppress/LessSuppressionUtil", "getSuppressedInBlockAtRule"));
        }
        return LessSuppressionUtil.getStatementToolSuppressedIn(element, toolId, CssAtRule.class);
    }

    @Nullable
    private static PsiElement getStatementToolSuppressedIn(@NotNull PsiElement element, @NotNull String toolId, @NotNull Class<? extends PsiElement> statementClass) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/less/inspections/suppress/LessSuppressionUtil", "getStatementToolSuppressedIn"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "org/jetbrains/plugins/less/inspections/suppress/LessSuppressionUtil", "getStatementToolSuppressedIn"));
        }
        if (statementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementClass", "org/jetbrains/plugins/less/inspections/suppress/LessSuppressionUtil", "getStatementToolSuppressedIn"));
        }
        PsiElement current = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{statementClass});
        while (current != null) {
            PsiElement result = SuppressionUtil.getStatementToolSuppressedIn((PsiElement)current, (String)toolId, statementClass);
            if (result != null) {
                return result;
            }
            current = PsiTreeUtil.getParentOfType((PsiElement)current, statementClass, (boolean)true);
        }
        return null;
    }

    @NotNull
    public static SuppressQuickFix[] getSuppressActions(@NotNull String toolId) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "org/jetbrains/plugins/less/inspections/suppress/LessSuppressionUtil", "getSuppressActions"));
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new LessSuppressForStatementCommentFix(toolId), new LessSuppressForRulesetCommentFix(toolId), new LessSuppressForMixinCommentFix(toolId), new LessSuppressForAtRuleCommentFix(toolId), new LessSuppressAllForRulesetCommentFix(), new LessSuppressAllForMixinCommentFix(), new LessSuppressAllForAtRuleCommentFix()};
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/inspections/suppress/LessSuppressionUtil", "getSuppressActions"));
        }
        return suppressQuickFixArray;
    }
}

