/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssPseudoClass;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.util.CssCompletionUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSElementTypes;
import org.jetbrains.plugins.less.LESSLanguage;
import org.jetbrains.plugins.less.completion.provider.LessMixinCompletionProvider;
import org.jetbrains.plugins.less.completion.provider.LessNamedArgumentCompletionProvider;
import org.jetbrains.plugins.less.completion.provider.LessNamespaceCompletionProvider;
import org.jetbrains.plugins.less.completion.provider.LessVariableCompletionProvider;
import org.jetbrains.plugins.less.lexer.LESSTokenTypes;
import org.jetbrains.plugins.less.psi.LESSMixinInvocation;
import org.jetbrains.plugins.less.psi.impl.LESSMixinName;
import org.jetbrains.plugins.less.psi.impl.LESSNamespace;
import org.jetbrains.plugins.less.psi.impl.LessNamedArgument;
import org.jetbrains.plugins.less.psi.impl.LessVariableInterpolationImpl;

public class LessCompletionContributor
extends CompletionContributor {
    public LessCompletionContributor() {
        this.extend(CompletionType.BASIC, LessCompletionContributor.variable(), new LessVariableCompletionProvider());
        this.extend(CompletionType.BASIC, LessCompletionContributor.namedArgument(), new LessNamedArgumentCompletionProvider());
        this.extend(CompletionType.BASIC, LessCompletionContributor.mixin(), new LessMixinCompletionProvider(true));
        this.extend(CompletionType.BASIC, LessCompletionContributor.mixinInRulesetBeginning(), new LessMixinCompletionProvider(false));
        this.extend(CompletionType.BASIC, LessCompletionContributor.namespace(), new LessNamespaceCompletionProvider(true));
        this.extend(CompletionType.BASIC, LessCompletionContributor.mixinInRulesetBeginning(), new LessNamespaceCompletionProvider(false));
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/less/completion/LessCompletionContributor", "beforeCompletion"));
        }
        PsiElement element = context.getFile().findElementAt(context.getStartOffset());
        if (CssPsiUtil.getStylesheetLanguage((PsiElement)element) == LESSLanguage.INSTANCE && PsiTreeUtil.getParentOfType((PsiElement)element, LessVariableInterpolationImpl.class, (boolean)false) != null) {
            context.setDummyIdentifier("IntellijIdeaRulezzz");
        }
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/less/completion/LessCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/less/completion/LessCompletionContributor", "fillCompletionVariants"));
        }
        super.fillCompletionVariants(parameters, CssCompletionUtil.fixPrefixForVendorPrefixes((CompletionParameters)parameters, (CompletionResultSet)result, (IElementType[])new IElementType[0]));
    }

    private static ElementPattern<? extends PsiElement> variable() {
        return PlatformPatterns.psiElement((IElementType)LESSTokenTypes.VARIABLE).withSuperParent(2, (ElementPattern)StandardPatterns.not((ElementPattern)PlatformPatterns.psiElement((IElementType)LESSElementTypes.LESS_NAMED_ARGUMENT)));
    }

    private static ElementPattern<? extends PsiElement> namedArgument() {
        return ((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)LESSTokenTypes.VARIABLE).inside(LESSMixinInvocation.class)).andOr(new ElementPattern[]{PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement((IElementType)LESSElementTypes.LESS_NAMED_ARGUMENT)), StandardPatterns.not((ElementPattern)PlatformPatterns.psiElement().inside(LessNamedArgument.class))});
    }

    private static ElementPattern<? extends PsiElement> mixinInRulesetBeginning() {
        return ((PsiElementPattern.Capture)LessCompletionContributor.inLessFile(LESSMixinName.MIXIN_NAME_TOKENS).inside(CssSelectorSuffix.class)).andNot((ElementPattern)PlatformPatterns.psiElement().inside(CssPseudoClass.class));
    }

    private static ElementPattern<? extends PsiElement> mixin() {
        return ((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(LESSMixinName.MIXIN_NAME_TOKENS)).withParent(LESSMixinName.class);
    }

    private static ElementPattern<? extends PsiElement> namespace() {
        return ((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(LESSMixinName.MIXIN_NAME_TOKENS)).inside(LESSNamespace.class);
    }

    public static PsiElementPattern.Capture<PsiElement> inLessFile(TokenSet tokenSet) {
        return (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(tokenSet)).inside((ElementPattern)PlatformPatterns.psiElement((IElementType)LESSElementTypes.LESS_STYLESHEET));
    }
}

