/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.annotator;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.browse.CssColorGutterRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.psi.LESSVariableDeclaration;
import org.jetbrains.plugins.less.psi.impl.LESSElementVisitor;
import org.jetbrains.plugins.less.psi.impl.LESSVariableImpl;

public class LessColorAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement psiElement, final @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/plugins/less/annotator/LessColorAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/less/annotator/LessColorAnnotator", "annotate"));
        }
        WebEditorOptions webEditorOptions = WebEditorOptions.getInstance();
        if (webEditorOptions == null || !webEditorOptions.isShowCssColorPreviewInGutter()) {
            return;
        }
        psiElement.accept((PsiElementVisitor)new LESSElementVisitor(){

            @Override
            public void visitLESSVariable(LESSVariableImpl variable) {
                PsiElement colorElement;
                PsiElement resolve;
                PsiReference[] references = variable.getReferences();
                if (references.length != 0 && !LessColorAnnotator.isDeclaration(variable) && (resolve = references[0].resolve()) instanceof LESSVariableDeclaration && (colorElement = ((LESSVariableDeclaration)resolve).getValue()) != null && CssColorGutterRenderer.getColor((PsiElement)colorElement) != null) {
                    Annotation annotation = holder.createInfoAnnotation((PsiElement)variable, null);
                    annotation.setGutterIconRenderer((GutterIconRenderer)new CssColorGutterRenderer(colorElement));
                }
            }
        });
    }

    private static boolean isDeclaration(LESSVariableImpl variable) {
        LESSVariableDeclaration declaration = (LESSVariableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)variable, LESSVariableDeclaration.class);
        return declaration != null && variable.equals(declaration.getNameIdentifier());
    }
}

