/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.css.CssFileType;
import icons.LessIcons;
import java.nio.charset.Charset;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.LESSBundle;
import org.jetbrains.plugins.less.LESSLanguage;
import org.jetbrains.plugins.less.editor.LESSEditorHighlighter;

public class LESSFileType
extends LanguageFileType {
    public static final LESSFileType LESS = new LESSFileType();
    @NonNls
    public static final String DEFAULT_EXTENSION = "less";
    @NonNls
    private static final String NAME = "Less";
    @NonNls
    private static final String DESCRIPTION = LESSBundle.message("filetype.description.less", new Object[0]);

    private LESSFileType() {
        super((Language)LESSLanguage.INSTANCE);
        FileTypeEditorHighlighterProviders.INSTANCE.addExplicitExtension((Object)this, (Object)new EditorHighlighterProvider(){

            public EditorHighlighter getEditorHighlighter(@Nullable Project project, @NotNull FileType fileType, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
                if (fileType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "org/jetbrains/plugins/less/LESSFileType$1", "getEditorHighlighter"));
                }
                if (colors == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "org/jetbrains/plugins/less/LESSFileType$1", "getEditorHighlighter"));
                }
                return new LESSEditorHighlighter(colors, project, virtualFile);
            }
        });
    }

    @NotNull
    public String getName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/LESSFileType", "getName"));
        }
        return NAME;
    }

    @NotNull
    public String getDescription() {
        String string = DESCRIPTION;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/LESSFileType", "getDescription"));
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        if (DEFAULT_EXTENSION == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/LESSFileType", "getDefaultExtension"));
        }
        return DEFAULT_EXTENSION;
    }

    @Nullable
    public Icon getIcon() {
        return LessIcons.Less;
    }

    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/less/LESSFileType", "getCharset"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/plugins/less/LESSFileType", "getCharset"));
        }
        Charset charset = CssFileType.getCharsetFromCssContent((byte[])content);
        return charset != null ? charset.name() : null;
    }

    public Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile file, @NotNull CharSequence content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/plugins/less/LESSFileType", "extractCharsetFromFileContent"));
        }
        return CssFileType.getCharsetFromCssContent((CharSequence)content);
    }
}

