/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import org.w3c.util.ArrayDictionary;
import org.w3c.www.http.BasicValue;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.ParseState;

public class HttpCredential
extends BasicValue {
    ArrayDictionary params = null;
    ArrayDictionary unqparams = null;
    String scheme = null;

    protected void parse() throws HttpParserException {
        ParseState parseState = new ParseState(this.roff, this.rlen);
        if (HttpParser.nextItem(this.raw, parseState) < 0) {
            this.error("Invalid credentials: no scheme.");
        }
        this.scheme = parseState.toString(this.raw);
        parseState.prepare();
        if (this.scheme.equalsIgnoreCase("basic")) {
            if (HttpParser.nextItem(this.raw, parseState) < 0) {
                this.error("Invalid basic auth credentials, no basic-cookie.");
            }
            if (this.unqparams == null) {
                this.unqparams = new ArrayDictionary(5, 5);
            }
            this.unqparams.put("cookie", parseState.toString(this.raw));
        } else {
            ParseState parseState2 = new ParseState();
            parseState2.separator = (byte)61;
            parseState.separator = (byte)44;
            while (HttpParser.nextItem(this.raw, parseState) >= 0) {
                parseState2.prepare(parseState);
                if (HttpParser.nextItem(this.raw, parseState2) < 0) {
                    this.error("Invalid credentials: bad param name.");
                }
                String string = parseState2.toString(this.raw, true);
                parseState2.prepare();
                if (HttpParser.nextItem(this.raw, parseState2) < 0) {
                    this.error("Invalid credentials: no param value.");
                }
                parseState2.ioff = parseState2.start;
                int n = HttpParser.skipSpaces(this.raw, parseState2);
                if (n < this.raw.length && this.raw[n] == 34) {
                    HttpParser.unquote(this.raw, parseState2);
                    if (this.params == null) {
                        this.params = new ArrayDictionary(5, 5);
                    }
                    this.params.put(string, parseState2.toString(this.raw));
                } else {
                    if (this.unqparams == null) {
                        this.unqparams = new ArrayDictionary(5, 5);
                    }
                    this.unqparams.put(string, parseState2.toString(this.raw));
                }
                parseState.prepare();
            }
        }
    }

    protected void updateByteValue() {
        String string;
        int n;
        int n2;
        HttpBuffer httpBuffer = new HttpBuffer();
        httpBuffer.append(this.scheme);
        httpBuffer.append(' ');
        if (this.params != null) {
            n2 = this.params.size();
            n = 0;
            while (n2 > 0) {
                string = (String)this.params.keyAt(n);
                if (string != null) {
                    if (string.equals("cookie")) {
                        httpBuffer.append((String)this.params.elementAt(n));
                    } else {
                        httpBuffer.appendQuoted(string, (byte)61, (String)this.params.elementAt(n));
                    }
                    if (--n2 > 0) {
                        httpBuffer.append((byte)44);
                        httpBuffer.append((byte)32);
                    }
                }
                ++n;
            }
        }
        if (this.unqparams != null) {
            n2 = this.unqparams.size();
            n = 0;
            while (n2 > 0) {
                string = (String)this.unqparams.keyAt(n);
                if (string != null) {
                    if (string.equals("cookie")) {
                        httpBuffer.append((String)this.params.elementAt(n));
                    } else {
                        httpBuffer.append(string, (byte)61, (String)this.params.elementAt(n));
                    }
                    if (--n2 > 0) {
                        httpBuffer.append((byte)44);
                        httpBuffer.append((byte)32);
                    }
                }
                ++n;
            }
        }
        this.raw = httpBuffer.getByteCopy();
        this.roff = 0;
        this.rlen = this.raw.length;
    }

    public Object getValue() {
        this.validate();
        return this;
    }

    public String getScheme() {
        this.validate();
        return this.scheme;
    }

    public void setScheme(String string) {
        if (this.scheme != null && !this.scheme.equalsIgnoreCase(string)) {
            this.invalidateByteValue();
        }
        this.scheme = string;
    }

    public String getAuthParameter(String string) {
        this.validate();
        String string2 = null;
        if (this.params != null) {
            string2 = (String)this.params.get(string);
        }
        if (string2 == null && this.unqparams != null) {
            string2 = (String)this.unqparams.get(string);
        }
        return string2;
    }

    public void setAuthParameter(String string, String string2, boolean bl) {
        this.invalidateByteValue();
        if (bl) {
            if (this.params == null) {
                this.params = new ArrayDictionary(4, 4);
            }
            this.params.put(string, string2);
        } else {
            if (this.unqparams == null) {
                this.unqparams = new ArrayDictionary(4, 4);
            }
            this.unqparams.put(string, string2);
        }
    }

    public void setAuthParameter(String string, String string2) {
        this.setAuthParameter(string, string2, true);
    }

    public HttpCredential(boolean bl, String string) {
        this.isValid = bl;
        this.scheme = string;
    }

    public HttpCredential() {
        this.isValid = false;
    }
}

