/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.upgrade;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.w3c.tools.resources.upgrade.Attribute;

public class ClassAttribute
extends Attribute {
    public String stringify(Object object) {
        return object instanceof Class ? ((Class)object).getName() : "<unknown-class>";
    }

    public boolean checkValue(Object object) {
        return object instanceof Class;
    }

    public final int getPickleLength(Object object) {
        String string = ((Class)object).getName();
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n2;
                continue;
            }
            if (c > '\u07ff') {
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        return n2 + 2;
    }

    public void pickle(DataOutputStream dataOutputStream, Object object) throws IOException {
        dataOutputStream.writeUTF(((Class)object).getName());
    }

    public Object unpickle(DataInputStream dataInputStream) throws IOException {
        String string = dataInputStream.readUTF();
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            throw new IOException("Unable to restore class " + string + ": " + exception.getMessage());
        }
    }

    public ClassAttribute(String string, Class clazz, Integer n) {
        super(string, clazz, n);
        this.type = "java.lang.Class";
    }
}

