/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.offline.command;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.w3c.tools.offline.browse.StoreFinder;
import org.w3c.tools.offline.command.CommandLine;
import org.w3c.tools.offline.command.CommandParseException;

public class CommandInterpreter {
    protected static StoreFinder sf = null;
    protected static boolean interactive = true;
    protected static BufferedReader reader = null;

    public CommandInterpreter(String[] stringArray) {
        boolean bl = true;
        if (stringArray.length < 2) {
            String[] stringArray2 = new String[]{"config/stores", "http-server"};
            System.out.println("assuming arguments are `config/stores http-server`");
            sf = new StoreFinder(stringArray2[0], stringArray2[1]);
        } else {
            if (stringArray.length > 3) {
                System.out.println("usage :");
                System.out.print("java org.w3c.tools.offline.command.Main ");
                System.out.print("stores_directory server [batch_file]\n");
                System.exit(1);
            }
            if (stringArray.length == 3) {
                System.out.println("entering batch mode...");
                bl = false;
            }
            sf = new StoreFinder(stringArray[0], stringArray[1]);
        }
        try {
            sf.readStoreIndex();
        }
        catch (IOException iOException) {
            System.out.println("Can't read store. Exiting.");
            System.exit(2);
        }
        try {
            sf.readStoreRoot();
        }
        catch (Exception exception) {
            System.out.println("can't find root file");
            System.exit(3);
        }
        if (bl) {
            this.runInteractive();
        } else {
            this.runScriptFile(stringArray[2]);
        }
    }

    private void runScriptFile(String string) {
        interactive = false;
        try {
            reader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("batch not found: " + string);
            System.exit(4);
        }
        this.run();
    }

    private void runInteractive() {
        interactive = true;
        reader = new BufferedReader(new InputStreamReader(System.in), 1);
        this.run();
    }

    private void run() {
        block2: while (true) {
            try {
                while (true) {
                    String string;
                    if (interactive) {
                        System.out.print(this.prompt());
                        System.out.flush();
                    }
                    if ((string = reader.readLine()) == null || string.equals("exit")) break block2;
                    CommandLine commandLine = new CommandLine(string);
                    this.ProcessCommand(commandLine);
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                continue;
            }
            break;
        }
    }

    private String prompt() {
        return "jigshell-alpha> ";
    }

    protected void ProcessCommand(CommandLine commandLine) {
        try {
            commandLine.parse();
            String string = commandLine.getAction();
            boolean bl = false;
            String string2 = commandLine.getOption();
            if (string2.indexOf(CommandLine.REC) != -1) {
                bl = true;
            }
            if (string2.indexOf(CommandLine.ATTR) != -1) {
                if (string.compareTo(CommandLine.LIST) == 0) {
                    string = "listatt";
                }
            }
            if (string != null) {
                if (string.compareTo(CommandLine.WHERE) == 0) {
                    sf.printWorkingRep();
                } else if (string.compareTo(CommandLine.GO) == 0) {
                    sf.setWorkingRep(commandLine.getTarget());
                } else {
                    sf.finderAction(string, commandLine.getTarget(), bl);
                }
            }
        }
        catch (CommandParseException commandParseException) {
            System.out.println("syntax error");
        }
    }
}

