/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.auth;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.w3c.jigsaw.auth.AuthFilter;
import org.w3c.jigsaw.auth.AuthRealm;
import org.w3c.jigsaw.auth.AuthUser;
import org.w3c.jigsaw.auth.DigestAuthFilterException;
import org.w3c.jigsaw.auth.RealmsCatalog;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.httpd;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.StringArrayAttribute;
import org.w3c.tools.resources.StringAttribute;
import org.w3c.util.StringUtils;
import org.w3c.www.http.HttpChallenge;
import org.w3c.www.http.HttpCredential;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpReplyMessage;

public class DigestAuthFilter
extends AuthFilter {
    protected static int ATTR_ALLOWED_USERS = -1;
    protected static int ATTR_ALLOWED_GROUPS = -1;
    protected static int ATTR_ALGORITHM = -1;
    protected static int ATTR_NONCE_TTL = -1;
    protected RealmsCatalog catalog = null;
    protected ResourceReference rr_realm = null;
    protected String loaded_realm = null;
    protected HttpChallenge challenge = null;
    protected String nonce = null;
    protected String old_nonce = null;
    private long prev_date = 0L;
    private int nonce_ttl = 600;

    protected synchronized void acquireRealm() {
        Object object;
        if (this.catalog == null) {
            object = (httpd)((FramedResource)this.getTargetResource()).getServer();
            this.catalog = ((httpd)object).getRealmsCatalog();
        }
        if ((object = this.getRealm()) == null) {
            return;
        }
        if (this.rr_realm != null && ((String)object).equals(this.loaded_realm)) {
            return;
        }
        this.rr_realm = this.catalog.loadRealm((String)object);
        this.loaded_realm = object;
    }

    protected synchronized boolean checkRealm() {
        this.acquireRealm();
        return true;
    }

    public String[] getAllowedUsers() {
        return (String[])this.getValue(ATTR_ALLOWED_USERS, null);
    }

    public String[] getAllowedGroups() {
        return (String[])this.getValue(ATTR_ALLOWED_GROUPS, null);
    }

    public String getAlgorithm() {
        return (String)this.getValue(ATTR_ALGORITHM, (Object)"MD5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResourceReference lookupUser(String string) {
        if (this.rr_realm == null) {
            this.acquireRealm();
        }
        try {
            AuthRealm authRealm = (AuthRealm)this.rr_realm.lock();
            ResourceReference resourceReference = authRealm.loadUser(string);
            return resourceReference;
        }
        catch (InvalidResourceException invalidResourceException) {
            ResourceReference resourceReference = null;
            return resourceReference;
        }
        finally {
            this.rr_realm.unlock();
        }
    }

    protected boolean checkUser(AuthUser authUser) {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3 = this.getAllowedUsers();
        if (stringArray3 != null) {
            for (int i = 0; i < stringArray3.length; ++i) {
                if (!stringArray3[i].equals(authUser.getName())) continue;
                return true;
            }
        }
        if ((stringArray2 = this.getAllowedGroups()) != null && (stringArray = authUser.getGroups()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (!stringArray2[j].equals(stringArray[i])) continue;
                    return true;
                }
            }
        }
        return stringArray3 == null && stringArray2 == null;
    }

    public void setValue(int n, Object object) {
        super.setValue(n, object);
        if (n == ATTR_REALM) {
            this.challenge = HttpFactory.makeChallenge("Digest");
            this.challenge.setAuthParameter("realm", this.getRealm());
        }
        if (n == ATTR_NONCE_TTL && object instanceof Integer) {
            this.nonce_ttl = (Integer)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(Request request) throws ProtocolException {
        Cloneable cloneable;
        Object object;
        if (!this.checkRealm()) {
            return;
        }
        Client client = request.getClient();
        if (client == null) {
            return;
        }
        Date date = new Date();
        if ((date.getTime() - this.prev_date) / 1000L > (long)this.nonce_ttl) {
            this.prev_date = date.getTime();
            this.updateNonce();
        }
        DigestAuthContext digestAuthContext = null;
        if (request.hasAuthorization() && !request.isProxy() || request.isProxy() && request.hasProxyAuthorization()) {
            try {
                digestAuthContext = new DigestAuthContext(request);
            }
            catch (DigestAuthFilterException digestAuthFilterException) {
                digestAuthContext = null;
            }
            if (digestAuthContext != null) {
                object = this.lookupUser(digestAuthContext.dac_user);
                try {
                    cloneable = (AuthUser)object.lock();
                    if (cloneable != null && ((AttributeHolder)cloneable).definesAttribute("password") && digestAuthContext.authenticate(((AuthUser)cloneable).getName(), this.loaded_realm, ((AuthUser)cloneable).getPassword())) {
                        request.setState("org.w3c.jigsaw.auth.AuthFilter.user", digestAuthContext.dac_user);
                        request.setState("org.w3c.jigsaw.auth.AuthFilter.type", "Digest");
                        request.setState("org.w3c.jigsaw.auth.AuthFilter.context", digestAuthContext);
                        return;
                    }
                }
                catch (InvalidResourceException invalidResourceException) {
                }
                finally {
                    object.unlock();
                }
            }
        }
        object = null;
        if (digestAuthContext != null && digestAuthContext.stale) {
            cloneable = this.challenge.getClone();
            if (cloneable != null) {
                ((HttpChallenge)cloneable).setAuthParameter("stale", "true", false);
            } else {
                cloneable = this.challenge;
            }
        } else {
            cloneable = this.challenge;
        }
        if (request.isProxy()) {
            object = request.makeReply(407);
            ((HttpReplyMessage)object).setProxyAuthenticate((HttpChallenge)cloneable);
        } else {
            object = request.makeReply(401);
            ((HttpReplyMessage)object).setWWWAuthenticate((HttpChallenge)cloneable);
        }
        HtmlGenerator htmlGenerator = new HtmlGenerator("Unauthorized");
        htmlGenerator.append("<h1>Unauthorized access</h1><p>You are denied access to this resource.");
        ((Reply)object).setStream(htmlGenerator);
        throw new HTTPException((Reply)object);
    }

    private void updateNonce() {
        this.updateNonce(this.getResource());
    }

    private synchronized void updateNonce(FramedResource framedResource) {
        if (framedResource instanceof HTTPFrame) {
            HTTPFrame hTTPFrame = (HTTPFrame)framedResource;
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(this.getAlgorithm());
                messageDigest.update(new Date().toString().getBytes());
                try {
                    messageDigest.update(hTTPFrame.getETag().getTag().getBytes());
                }
                catch (Exception exception) {
                    messageDigest.update(hTTPFrame.getURLPath().getBytes());
                }
                byte[] byArray = messageDigest.digest();
                if (this.nonce != null) {
                    this.old_nonce = this.nonce;
                }
                this.nonce = StringUtils.toHexString(byArray);
                this.challenge.setAuthParameter("nonce", this.nonce);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
    }

    public ReplyInterface outgoingFilter(RequestInterface requestInterface, ReplyInterface replyInterface) {
        Request request = (Request)requestInterface;
        Reply reply = (Reply)replyInterface;
        if (this.getPrivateCachability()) {
            reply.setMustRevalidate(true);
        } else if (this.getSharedCachability()) {
            reply.setProxyRevalidate(true);
        } else if (this.getPublicCachability()) {
            reply.setPublic(true);
        }
        if (request.hasState("org.w3c.jigsaw.auth.AuthFilter.context")) {
            DigestAuthContext digestAuthContext = (DigestAuthContext)request.getState("org.w3c.jigsaw.auth.AuthFilter.context");
            if (digestAuthContext.stale) {
                reply.addAuthenticationInfo("nextnonce", this.nonce);
            }
        }
        return null;
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
        if (this.getRealm() != null) {
            this.challenge = HttpFactory.makeChallenge("Digest");
            this.challenge.setAuthParameter("realm", this.getRealm());
            this.updateNonce();
            this.challenge.setAuthParameter("domain", this.getURLPath());
            this.challenge.setAuthParameter("algorithm", this.getAlgorithm(), false);
        }
    }

    static {
        Attribute attribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.auth.DigestAuthFilter");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        attribute = new StringArrayAttribute("users", null, 2);
        ATTR_ALLOWED_USERS = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringArrayAttribute("groups", null, 2);
        ATTR_ALLOWED_GROUPS = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringAttribute("algorithm", null, 2);
        ATTR_ALGORITHM = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new IntegerAttribute("nonce_ttl", new Integer(300), 2);
        ATTR_NONCE_TTL = AttributeRegistry.registerAttribute(clazz, attribute);
    }

    public class DigestAuthContext {
        String dac_user = null;
        String dac_realm = null;
        String dac_nonce = null;
        String dac_uri = null;
        String dac_response = null;
        String dac_algorithm = null;
        String dac_method = null;
        boolean stale = false;

        DigestAuthContext(Request request) throws DigestAuthFilterException, ProtocolException {
            HttpCredential httpCredential = null;
            HttpCredential httpCredential2 = httpCredential = request.isProxy() ? request.getProxyAuthorization() : request.getAuthorization();
            if (!httpCredential.getScheme().equalsIgnoreCase("Digest")) {
                String string = "Invalid authentication scheme \"" + httpCredential.getScheme() + " expecting \"Digest\"";
                throw new DigestAuthFilterException(string);
            }
            this.dac_user = httpCredential.getAuthParameter("username");
            this.dac_uri = httpCredential.getAuthParameter("uri");
            this.dac_response = httpCredential.getAuthParameter("response");
            this.dac_realm = httpCredential.getAuthParameter("realm");
            this.dac_method = request.getMethod();
            this.dac_nonce = httpCredential.getAuthParameter("nonce");
            if (this.dac_user == null || this.dac_uri == null || this.dac_response == null || this.dac_realm == null) {
                String string = "Invalid authentication header";
                throw new DigestAuthFilterException(string);
            }
        }

        boolean authenticate(String string, String string2, String string3) {
            this.stale = false;
            if (!this.dac_user.equals(string)) {
                return false;
            }
            if (!this.dac_realm.equals(string2)) {
                return false;
            }
            if (this.dac_algorithm != null && !this.dac_algorithm.equals(DigestAuthFilter.this.getAlgorithm())) {
                return false;
            }
            if (!this.dac_nonce.equals(DigestAuthFilter.this.nonce)) {
                if (!this.dac_nonce.equals(DigestAuthFilter.this.old_nonce)) {
                    String string4 = string + ":" + string2 + ":" + string3;
                    String string5 = this.dac_method + ":" + this.dac_uri;
                    MessageDigest messageDigest = null;
                    try {
                        messageDigest = MessageDigest.getInstance(DigestAuthFilter.this.getAlgorithm());
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        return false;
                    }
                    messageDigest.update(string4.getBytes());
                    String string6 = StringUtils.toHexString(messageDigest.digest());
                    messageDigest.reset();
                    messageDigest.update(string5.getBytes());
                    String string7 = StringUtils.toHexString(messageDigest.digest());
                    messageDigest.reset();
                    String string8 = string6 + ":" + this.dac_nonce + ":" + string7;
                    messageDigest.update(string8.getBytes());
                    String string9 = StringUtils.toHexString(messageDigest.digest());
                    this.stale = string9.equals(this.dac_response);
                    return false;
                }
                this.stale = true;
            }
            String string10 = string + ":" + string2 + ":" + string3;
            String string11 = this.dac_method + ":" + this.dac_uri;
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance(DigestAuthFilter.this.getAlgorithm());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return false;
            }
            messageDigest.update(string10.getBytes());
            String string12 = StringUtils.toHexString(messageDigest.digest());
            messageDigest.reset();
            messageDigest.update(string11.getBytes());
            String string13 = StringUtils.toHexString(messageDigest.digest());
            messageDigest.reset();
            String string14 = this.stale ? string12 + ":" + DigestAuthFilter.this.old_nonce + ":" + string13 : string12 + ":" + DigestAuthFilter.this.nonce + ":" + string13;
            messageDigest.update(string14.getBytes());
            String string15 = StringUtils.toHexString(messageDigest.digest());
            return string15.equals(this.dac_response);
        }
    }
}

